<!DOCTYPE html>
<html lang="en-US">
    <head>
        <style>
            table {
                width: 100%; 
                font-family: Arial;
                font-size: 12pt;
                color: #000; 
                line-height: 1.5;
                margin: auto; 
                border-collapse: collapse;   
            }
            td {
                text-align: left;
            }
            .address{
                font-weight: 500; 
            }
            .title{
                font-weight: bold;
            }       
        </style>
    </head>
    <body>
        <?php $companyProfile = getCompanyProfile(); ?>
        <h3>Dear {{ $body['user_name'] }}</h3>
        <table border="0" cellpadding="10" cellspacing="0" align="center" width="100%">
            <tr>
                <td><img src="{{ asset($companyProfile["company_logo"]) }}" style="width:175px;"></td>
            </tr>
            <tr>
                <td class="address"><span style="font-weight:bold">Address:</span><br /> {!! $companyProfile["header"] !!}</td>
            </tr>
            <tr>
                <td class="title" width="30%">Date:</td>
                <td width="70%">{{ $body['created_at'] }}</td>
            </tr>
            <tr>
                <td class="title" width="30%">Product:</td>
                <td width="70%">{{ $body['product_name'] }}</td>
            </tr>
            <tr>
                <td class="title" width="30%">Value:</td>
                <td width="70%">{{ getGlobalValue('currency') }}{{ $body['amount'] }}</td>
            </tr>
            <tr>
                <td class="title" width="30%">Pin:</td>
                <td width="70%">{{ $body['pin_number'] }}</td>
            </tr>
            <tr>
                <td class="title" width="30%">Serial:</td>
                <td width="70%">{{ $body['serial_number'] }}</td>
            </tr>
            <tr>
                <td colspan="4">{!! $body['description'] !!}</td>
            </tr>
            <tr>
                <td colspan="4">{!! $companyProfile["description"] !!}</td>
            </tr>
            <tr>
                <td colspan="4"><hr>{!! $companyProfile["footer"] !!}</td>
            </tr>
            <tr>
                <td colspan="4">Regards <br/>{{ Config::get('acl_base.app_name') }} Team</td>
            </tr>
        </table>
    </body>    
</html>
