<!DOCTYPE html>
<html lang="en-US">
    <head>
        <style>
            table {
                width: 100%; 
                font-family: Arial;
                font-size: 12pt;
                color: #000; 
                line-height: 1.5;
                margin: auto; 
                border-collapse: collapse;   
            }
            td {
                text-align: left;
            }
            .address{
                font-weight: 500; 
            }
            .title{
                font-weight: bold;
            }       
        </style>
    </head>
    <body>
        <table border="0" cellpadding="10" cellspacing="0" align="center" width="100%">
            <tr>
                <td><img src="{{ asset($body['company_logo']) }}" style="width:175px;"></td>
            </tr>
            <tr>
                <td class="address"><span style="font-weight:bold">Address:</span><br /> {!! $body['header'] !!}</td>
            </tr>
            <tr>
                <td colspan="4"><h3>Dear {{ $body['user_name'] }},</h3></td>
            </tr>
            <tr>
                <td colspan="4">
                    @if($body['status'] == 0) <!-- 0 => Pending/New Order -->
                        New Order Information:
                    @else
                        Order Information Order #: {{ $body['order_no'] }}
                    @endif
                    <hr></td>
            </tr>
            <tr>
                <td class="title" width="30%">Email:</td>
                <td width="70%">{{ $body['email'] }}</td>
            </tr>
            <tr>
                <td class="title" width="30%">IMEI:</td>
                <td width="70%">{{ $body['imei'] }}</td>
            </tr>
            <tr>
                <td class="title" width="30%">Order #:</td>
                <td width="70%">{{ $body['order_no'] }}</td>
            </tr>
            <tr>
                <td class="title" width="30%">Order Date:</td>
                <td width="70%">{{ $body['order_date'] }}</td>
            </tr>
            @if($body['previous_balance'] > 0)
                <tr>
                    <td class="title" width="30%">Your Previous Balance:</td>
                    <td width="70%">{{ getGlobalValue('currency') }}{{ $body['previous_balance'] }}</td>
                </tr>
            @endif
            @if($body['current_balance'] > 0)
                <tr>
                    <td class="title" width="30%">Your Current Balance:</td>
                    <td width="70%">{{ getGlobalValue('currency') }}{{ $body['current_balance'] }}</td>
                </tr>
            @endif
            <tr>
                <td colspan="4"><hr></td>
            </tr>
            <tr>
                <td class="title" width="30%">Service:</td>
                <td width="70%">{{ $body['service'] }}</td>
            </tr>
            <tr>
                <td class="title" width="30%">
                    @if(($body['status'] == 2 && $body['current_balance'] > 0) || $body['status'] == 4) <!-- 2 => Reject, 4 => Cancel -->
                        Refund:
                    @else
                        Paid:
                    @endif
                </td>
                <td width="70%">{{ getGlobalValue('currency') }}{{ $body['amount'] }}</td>
            </tr>
            <tr>
                <td colspan="4">
                    @if($body['status'] == 0)
                        Thank you for your order(s), it has been placed and will be readily available to you via your email address.<br><br> 
                        Thank you very much for your custom.
                    @elseif($body['status'] == 1 || $body['status'] == 2) <!-- 1 => Completed, 2 => Reject -->
                        {{ $body['response'] }}
                    @endif
                </td>
            </tr>
            <tr>
                <td colspan="4">Regards <br/>{{ Config::get('acl_base.app_name') }} Team</td>
            </tr>
        </table>
    </body>    
</html>