<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-settings"></i>
                    Network Commission
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-toolbar">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="btn-group">
                                <a href="#basic" data-toggle="modal" class="btn sbold green"> 
                                    Add New <i class="fa fa-plus"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <table class="table table-striped table-bordered table-hover datatable">
                    <thead> 
                        <tr>
                            <th>Network</th>
                            @for($i = 1; $i <= $networkCommission->topup_level; $i++)
                                <th>Top Up {{ $i }}</th>
                            @endfor
                        </tr>
                    </thead>
                    <tbody>
                        <?php $networkNames = array();?>
                        @foreach($networkCommissionScheme as $row)
                            <?php $networkName = $row->network->name;?>
                            @if($loop->first)
                                <tr>
                            @endif
                            @if(!in_array($networkName, $networkNames))
                                <?php $networkNames[] = $networkName; ?>
                                @if(!$loop->first)
                                    </tr><tr>
                                @endif
                                <td>{{ $networkName }}</td>
                            @endif
                                <td>
                                    <a href="javascript:;" class="commission" data-pk="{{ $row->id }}">
                                        {{ $row->commission }}
                                    </a>
                                </td>
                            @if($loop->last)
                                </tr>
                            @endif
                        @endforeach    
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@include('network_commission.add_network_commission_scheme')
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
//----------------------------------X-Editable----------------------------------

        //global settings 
        $.fn.editable.defaults.inputclass = 'form-control';
        
        $('.commission').on('init', function(e, edit) 
        {
            edit.options.url = base_url+'/network_commission/edit_network_commission_scheme';
        });
        
//-------------------------------Edit Commission--------------------------------

        $('.commission').editable({
            type: 'text',
            params: {
                data_type: 'digits',
                _token: '{{ csrf_token() }}'
            },
            validate: function (value) {
                 if ($.trim(value) == '')
                    return 'This field is required.';
                if (!$.isNumeric(value))
                    return 'This field must be a number.';
            },
            success: function(response) {
                if(response != '') return response;
            },
            error: function(data) {
                var response = $.parseJSON(data.responseText);
                toastr_call(2, response.value);
            }
        });
        
//--------------------------------Update Status---------------------------------

        $('.update_status').click(function()
        {
            var message;
            var id   = $(this).attr('id');
            var status = $(this).children('button').attr('id');
            
            if(status == 1)
            {
                status  = 0;
                message = 'Are you sure you want to inactive status?';
            }else
            {
                status  = 1;
                message = 'Are you sure you want to active status?';
            }
            
            var data = 'id='+id+'&status='+status+'&_token={{ csrf_token() }}';
            var url  = base_url +'/network_commission/update_status';
            var return_url = base_url+'/network_commission';
            
            bootbox.confirm(message, function(result) 
            {
                if(result == true)
                {
                   ajax_call2(data, url, return_url);
                }
            });
            return false;    
        });
        
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
    });
</script>