<div class="col-md-12">
    <div class="portlet box green">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                Network Incentive List
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-toolbar">
                <div class="row">
                    <div class="col-md-12">
                        <div class="btn-group">
                            <a href="#basic" class="btn sbold green" data-toggle="modal">
                                Import Incentive Report <i class="fa fa-download"></i>
                            </a>
                        </div>
                        <div id="action_btn" class="btn-group">
                            <button data-toggle="dropdown" class="btn sbold green dropdown-toggle" aria-expanded="true">
                                Action <i class="fa fa-angle-down"></i>
                            </button>
                            <ul class="dropdown-menu">
                                <li>    
                                    <a href="javascript:;" id="apply_network_incentive">
                                        <i class="fa fa-check-circle-o"></i> Apply Network Incentive
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:;" id="pay_network_incentive">
                                        <i class="fa fa-times-circle-o"></i> Pay Network Incentive
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-body">
                {{ Form::open(['url' => 'network_commission/network_incentive_list', 'method' => 'get', 'id' => 'network_incentive_list', 'class' => 'form-horizontal']) }}
                    <div class="form-group margin-top-20 margin-bottom-40">
                        <label class="col-md-1 control-label">From</label>
                        <div class="col-md-4">
                            <div class="input-icon right">
                                <i class="fa fa-calendar"></i>
                                {{ Form::text('date_from', $dateFrom, ['class' => 'form-control date-picker', 'autocomplete' => 'off']) }}
                            </div>
                        </div>
                        <label class="col-md-1 control-label">To</label>
                        <div class="col-md-4">
                            <div class="input-icon right">
                                <i class="fa fa-calendar"></i>
                                {{ Form::text('date_to', $dateTo, ['class' => 'form-control date-picker', 'autocomplete' => 'off']) }}
                            </div>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-sm yellow filter-submit"><i class="fa fa-search"></i> Search</button>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
            <table id="datatable" class="table table-striped table-bordered table-hover margin-top-20">
                <thead>						
                    <tr>
                        <th>Date & Time</th>
                        <th>User</th>
                        <th>SIM Number</th>
                        <th>Topup Level</th>
                        <th>Topup Facevalue({{ getGlobalValue('currency') }})</th>
                        <th>Cost Incentives</th>
                        <th>Incentive({{ getGlobalValue('currency') }})</th>
                        <th>SusPected Deduction</th>
                        <th>Bundle Incentives</th>
                        <th>Status</th>
                    </tr>
                </thead>	
                <tbody>                       
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="modal fade" id="basic" tabindex="-1" role="basic" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title">Import Incentive Report</h4>
            </div>
            {{ Form::open(['url' => 'network_commission/import_network_incentive', 'id' => 'import_network_incentive', 'files' => true, 'class' => 'form-horizontal']) }}
                <div class="modal-body">             
                    <div class="row">
                        <div class="form-group">
                            <label class="control-label col-md-3">
                                File<span class="required"> * </span>
                            </label>
                            <div class="col-md-3">
                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                    <div class="input-group input-large">
                                        <div class="form-control uneditable-input input-fixed input-medium" data-trigger="fileinput">
                                            <i class="fa fa-file fileinput-exists"></i>&nbsp;
                                            <span class="fileinput-filename"> </span>
                                        </div>
                                        <span class="input-group-addon btn default btn-file">
                                            <span class="fileinput-new"> Select File </span>
                                            <span class="fileinput-exists"> Change </span>
                                            {{ Form::file('file', ['id' => 'file']) }}
                                        </span>
                                        <a href="javascript:;" class="input-group-addon btn red fileinput-exists" id="remove" data-dismiss="fileinput"> Remove </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn dark btn-outline" data-dismiss="modal">Close</button>
                    {{ Form::submit('Upload', ['class' => 'btn green', 'id' => 'upload']) }}                                
                </div>
            {{ Form::close() }}
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//------------------------------Topup List Lookup-------------------------------

        $('#network_incentive_list').submit(function()
        {
            lookup($(this));
            return false;        
        });  
        
        var table = $('#datatable');

        table.DataTable({
            'processing': true,
            'serverSide': true,
            'pageLength': 25,
            'pagingType': 'bootstrap_extended',
            'ajax': base_url+'/network_commission/get_network_incentive_data?from={{ $from }}&to={{ $to }}',
            'ordering': false,
            'columns': [
                { data: 'product_date' },
                { data: 'sim_information_data.agent_id' },
                { data: 'sim_number' },
                { data: 'topup_level' },
                { data: 'topup_face_value' },
                { data: 'product_incentive' },
                { data: 'incentive'},
                { data: 'suspected_deduction'},
                { data: 'boundle_incentives'},
                { data: 'status'}
            ]
        });        
        
//---------------------------Apply Network Incentive----------------------------

        $('#apply_network_incentive').click(function()
        {   
            var data = 'date_from={{ $from }}&date_to={{ $to }}&_token={{ csrf_token() }}';
            
            var url = base_url +'/network_commission/apply_network_incentive';
            var return_url = base_url +'/network_commission/network_incentive_list';
            
            bootbox.confirm("Are you sure you want to apply network incentive?", function(result) 
            {
                if(result == true)
                {
                    ajax_call2(data, url, return_url);
                }
            });
        });
        
//----------------------------Pay Network Incentive-----------------------------

        $('#pay_network_incentive').click(function()
        {   
            var data = 'date_from={{ $from }}&date_to={{ $to }}&_token={{ csrf_token() }}';
            
            var url = base_url +'/network_commission/pay_network_incentive';
            var return_url = base_url +'/network_commission/network_incentive_list';
            
            bootbox.confirm("Are you sure you want to pay network incentive?", function(result) 
            {
                if(result == true)
                {
                    ajax_call2(data, url, return_url);
                }
            });
        });
    });
</script>
