<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i>
                    Add Pin Number
                </div>
            </div>
            <div class="portlet-body">
                {{ Form::open(['url' => '/pin_numbers', 'id' => 'pin_number', 'class' => 'form-horizontal']) }}
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Category<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCategoriesAdmin() }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Amount<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::select('amount', ['' => 'Select Amount'], null, ['class' => 'form-control select2', 'id' => 'amount']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Expired Date<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('expired_date', null, ['class' => 'form-control date-picker']) }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Product<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::select('product_id', ['' => 'Select Product'], null, ['class' => 'form-control select2', 'id' => 'product_id']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Sale Price<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('sale_price', null, ['class' => 'form-control touchspin']) }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <h4 class="margin-top-40">Pin Numbers</h4><hr>
                            </div>
                            <div class="col-md-12 margin-top-20 pin_numbers">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label margin-bottom-10">
                                                PIN Number<span class="required"> * </span>
                                            </label>
                                            {{ Form::text('pin_number[]', null, ['class' => 'form-control']) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label margin-bottom-10">
                                                Serial Number<span class="required"> * </span>
                                            </label>
                                            {{ Form::text('serial_number[]', null, ['class' => 'form-control']) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-1" style="margin-top: 35px">
                                    <a href="javascript:;" id="add_pin_number" class="btn btn-icon-only green">
                                        <i class="fa fa-plus"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-offset-2 col-md-10">
                                {{ Form::submit('Submit', ['class' => 'btn green']) }}
                                <button type="button" id="cancel" class="btn default">Cancel</button>
                            </div>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
//---------------------------------Get Products---------------------------------

        $('#category_id').change(function()
        {
            var category_id = $(this).val();
            
            if(category_id != '')
            {
                $.get('transactions/'+category_id+'/get_products', function(data) 
                {
                    $('#product_id').html(data);
                });
            }else
            {
                $('#product_id').html('');
            }
        });
        
//------------------------------Get Product Amount------------------------------

        $('#product_id').change(function()
        {
            var product_id = $(this).val();
         
            if(product_id != '')
            {
                $.get(base_url+'/products/'+product_id+'/get_amount', function(data)
                {
                    $('#amount').html(data);
                });
            }else
            {
                $('#amount').html('');
            }
        });
        
//----------------------------------Add Price-----------------------------------
        
        $('#add_pin_number').click(function()
        {
            var add = $('<div class="col-md-12 pin_numbers">'+
                            '<div class="col-md-4">'+
                                '<div class="form-group">'+
                                    '<div class="col-md-12">'+
                                       '{{ Form::text("pin_number[]", null, ["class" => "form-control"]) }}'+
                                    '</div>'+
                                '</div>'+
                            '</div>'+
                            '<div class="col-md-4">'+
                                '<div class="form-group">'+
                                    '<div class="col-md-12">'+
                                        '{{ Form::text("serial_number[]", null, ["class" => "form-control"]) }}'+
                                    '</div>'+
                                '</div>'+
                            '</div>'+
                            '<div class="col-md-1">'+
                                '<a href="javascript:;" class="btn btn-icon-only red delete_pin_numbers">'+
                                    '<i class="fa fa-minus"></i>'+
                                '</a>'+
                            '</div>'+
                        '</div>');
            
            $(".pin_numbers:last").after(add);
            return false;
        });
        
//---------------------------------Remove Price---------------------------------

        $('.form-horizontal').on('click', '.delete_pin_numbers', function()
        {
            $(this).parent().parent().remove();
            return false;
        });
        
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/pin_numbers';
            return_page(url);
            return false;
        });
    });
</script>