<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i>
                    Edit Pin Number
                </div>
            </div>
            <div class="portlet-body">
                {{ Form::model($pinNumber, [
                    'method' => 'PATCH',
                    'url' => ['/pin_numbers', $pinNumber->id],
                    'id' => 'pin_number', 'class' => 'form-horizontal'
                ]) }}
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Category<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCategoriesAdmin($pinNumber->product->category_id) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Amount<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getProductAmount($pinNumber->product_id) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        PIN Number<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('pin_number', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Expired Date<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('expired_date', null, ['class' => 'form-control date-picker']) }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Product<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getProducts($pinNumber->product->category_id) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Sale Price<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('sale_price', null, ['class' => 'form-control touchspin']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Serial Number<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('serial_number', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-offset-2 col-md-10">
                                {{ Form::submit('Submit', ['class' => 'btn green']) }}
                                <button type="button" id="cancel" class="btn default">Cancel</button>
                            </div>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
//---------------------------------Get Products---------------------------------

        $('#category_id').change(function()
        {
            var category_id = $(this).val();
            
            if(category_id != '')
            {
                $.get('transactions/'+category_id+'/get_products', function(data) 
                {
                    $('#product_id').html(data);
                });
            }else
            {
                $('#product_id').html('');
            }
        });
        
//------------------------------Get Product Amount------------------------------

        $('#product_id').change(function()
        {
            var product_id = $(this).val();
         
            if(product_id != '')
            {
                $.get(base_url+'/products/'+product_id+'/get_amount', function(data) 
                {
                    $('#amount').html(data);
                });
            }else
            {
                $('#amount').html('');
            }
        });
        
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/pin_numbers';
            return_page(url);
            return false;
        });
    });
</script>