<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-settings"></i>
                    Pin Numbers Summary Report
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover datatable">
                    <thead> 
                        <tr>
                            <th>Product</th>
                            <th>Amount</th>
                            <th>Used</th>
                            <th>Remaining</th>
                            <th>Total</th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach($pinNumbers as $row)
                            <?php $remaining = $row->total - $row->used; ?>
                            <tr>
                                <td>{{ $row->product->name }}</td>
                                <td>{{ $row->amount }}</td>
                                <td>
                                    @if($row->used == 0)
                                        0
                                    @else
                                        <a href="{{ url('/pin_numbers?product_id='.$row->product_id.'&amount='.$row->amount.'&status=2')}}" class="ajaxify">{{ $row->used }}</a>
                                    @endif
                                </td>
                                <td>
                                    @if($remaining == 0)
                                        0
                                    @else
                                        <a href="{{ url('/pin_numbers?product_id='.$row->product_id.'&amount='.$row->amount.'&status=4')}}" class="ajaxify">{{ $remaining }}</a>
                                    @endif
                                </td>
                                <td><a href="{{ url('/pin_numbers?product_id='.$row->product_id.'&amount='.$row->amount)}}" class="ajaxify">{{ $row->total }}</a></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
    });
</script>