<?php $class = ($page == 1)?'green':'red';?>
@if($page == 2)
    <div class="title">
        <span class="offer">{{ $title }}</span>
    </div>
@endif
<div class="col-md-12">
    @if($page == 2)
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>
                    <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
                </li>
                <li>
                    <a href="{{ URL::route('reports') }}" class="ajaxify">Reports</a>
                </li>
                <li class="active">{{ $title }}</li>
            </ol>
        </div>
    @endif
    <div class="portlet box {{ $class }}">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                {{ $title }}
            </div>
        </div>
        <div class="portlet-body">
            <div class="form-body">
                {{ Form::open(['route' => 'banking_list', 'method' => 'get', 'id' => 'banking_list', 'class' => 'form-horizontal']) }}
                    @include('reports.filter')
                {{ Form::close() }}
            </div>
            <table class="table table-striped table-bordered table-hover margin-top-20" id="datatable">
                <thead>						
                    <tr>
                        <th>Transaction Id</th>
                        <th>Date</th>
                        <th>Bank</th>
                        <th>Amount</th>
                        <th>Payment Ref</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>

                </tbody>
            </table>                
        </div>
    </div>
</div>
<div class="modal fade" id="receipt" tabindex="-1" role="basic" aria-hidden="true">
     <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
@if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
    @include('reports.user_lookup',['groupId' => 4])
@endif
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//-----------------------------Banking List Lookup------------------------------

        $('#banking_list').submit(function()
        {
            lookup($(this));
            return false;        
        });  
        
        var table = $('#datatable');

        table.DataTable({
            'processing': true,
            'serverSide': true,
            'pageLength': 25,
            'pagingType': 'bootstrap_extended',
            'ajax': base_url+'/banking/get_data?page={{ $page }}&user_id={{ $userId }}&date_from={{ $dateFrom }}&date_to={{ $dateTo }}',
            'order': [
                [0, 'desc']
            ],
            'columns': [
                { data: 'transaction_id' },
                { data: 'date' },
                { data: 'bank.name', name: 'bank.name' },
                { data: 'amount' },
                { data: 'payment_ref' },
                { data: 'approved' }
            ]
        });
        
//-----------------------------------Approved-----------------------------------

        @if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
            
            $('#datatable').on('click', '.approved', function()
            {
                var id = $(this).attr('id');
                var message = 'Are you sure you want to approved?';
                var data = 'id='+id+'&approved=1&_token={{ csrf_token() }}';
                var url  = base_url +'/admin/banking_approved';
                var return_url = base_url+'/reports/banking_list';

                bootbox.confirm(message, function(result) 
                {
                    if(result == true)
                    {
                       ajax_call2(data, url, return_url);
                    }
                });
                return false;    
            });
        @endif
    });
</script>