<?php $class = ($page == 1)?'green':'red';?>
@if($page == 2)
    <div class="title">
        <span class="offer">{{ $title }}</span>
    </div>
@endif
<div class="col-md-12">
    @if($page == 2)
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>
                    <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
                </li>
                <li>
                    <a href="{{ URL::route('reports') }}" class="ajaxify">Reports</a>
                </li>
                <li class="active">{{ $title }}</li>
            </ol>
        </div>
    @endif
    <div class="portlet box {{ $class }}">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                {{ $title }}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-toolbar">
                <div class="row">
                    <div class="col-md-12">
                        <div class="btn-group" id="action_btn">
                            <button aria-expanded="false" class="btn sbold green dropdown-toggle" data-toggle="dropdown">
                                Action <i class="fa fa-angle-down"></i>
                            </button>
                            <ul class="dropdown-menu">
                                <li>    
                                    <a href="#courier_modal" data-toggle="modal">
                                        <i class="fa fa-check-circle-o"></i> Collect
                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:;" id="deliver" status="2">
                                        <i class="fa fa-times-circle-o"></i> Deliver
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-body">
                {{ Form::open(['route' => 'courier_services_list', 'method' => 'get', 'id' => 'courier_list', 'class' => 'form-horizontal']) }}
                    {{ Form::hidden('type', $type) }}
                    {{ Form::hidden('cargo_type', $cargoType) }}
                    {{ Form::hidden('page', $page) }}
                    <div class="form-group">
                        @if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
                            {{ Form::hidden('user_id', $userId, ['id' => 'user_id']) }}
                            <div class="col-md-3">
                                <label class="control-label margin-bottom-10">User Name</label>
                                {{ Form::text('user_name', $userName, ['id' => 'user_name', 'readonly' => '', 'class' => 'form-control']) }}
                            </div>
                            <div class="col-md-1" style="margin-top: 38px; padding-left:2px">
                                <a href="#basic" data-toggle="modal" class="btn green">Lookup</a>
                            </div>
                        @endif
                        <div class="col-md-2">
                            <label class="control-label margin-bottom-10">From</label>
                            <div class="input-icon right">
                                <i class="fa fa-calendar"></i>
                                {{ Form::text('date_from', $dateFrom, ['class' => 'form-control date-picker', 'autocomplete' => 'off']) }}
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label class="control-label margin-bottom-10">To</label>
                            <div class="input-icon right">
                                <i class="fa fa-calendar"></i>
                                {{ Form::text('date_to', $dateTo, ['class' => 'form-control date-picker', 'autocomplete' => 'off']) }}
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label class="control-label margin-bottom-10">Country</label>
                            {{ getCountries('country_id', $countryId) }}
                        </div>
                        <div class="col-md-2 margin-top-40">
                            <button class="btn btn-sm green filter-submit"><i class="fa fa-search"></i> Search</button>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
            <table class="table table-striped table-bordered table-hover margin-top-20" id="datatable">
                <thead>						
                    <tr>
                        <th>Order #</th>
                        <th>Order Date</th>
                        <th>Tracking Number</th>
                        <th>Parcel Contents</th>
                        <th>Amount({{ getGlobalValue('currency') }})</th>
                        <th>Status</th>
<!--                        <th>Details</th>-->
                    </tr>
                </thead>	
                <tbody>                       
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="modal fade" id="receipt" tabindex="-1" role="basic" aria-hidden="true">
     <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
<div class="modal fade" id="courier_modal" tabindex="-1" role="basic" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title">{{ $title }}</h4>
            </div>
            {{ Form::open(['id' => 'collect_courier', 'class' => 'form-horizontal']) }}
                {{ Form::hidden('status', 1) }}
                <div class="modal-body">  
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label col-md-2">
                                    Tracking Number
                                </label>
                                <div class="col-md-10">
                                    {{ Form::text('tracking_number', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn dark btn-outline" data-dismiss="modal">Close</button>
                    {{ Form::submit('Submit', ['id' => 'collect', 'class' => 'btn green']) }}                                
                </div>
            {{ Form::close() }}
        </div>
    </div>
</div>
@if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
    @include('reports.user_lookup',['groupId' => 4])
@endif
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();

        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//-----------------------------Courier List Lookup------------------------------

        var filter = 'page={{ $page }}&type={{ $type }}&cargo_type={{ $cargoType }}&user_id={{ $userId }}&date_from={{ $dateFrom }}&date_to={{ $dateTo }}&country_id={{ $countryId }}';

        $('#courier_list').submit(function()
        {
            lookup($(this));
            return false;        
        });  
        
        var table = $('#datatable');

        table.DataTable({
            'processing': true,
            'serverSide': true,
            'pageLength': 25,
            'pagingType': 'bootstrap_extended',
            'ajax': base_url+'/courier_services/get_data?'+filter,
            'order': [
                [0, 'desc']
            ],
            'columns': [
                { data: 'transaction_id' },
                { data: 'created_at' },
                { data: 'tracking_number' },
                { data: 'parcel_contents' },
                @if($type == 1)
                    { data: 'total_price' },
                @elseif($type == 2)
                    { data: 'total' },
                @endif
                { data: 'status' },
//                { data: 'action', orderable: false, searchable: false}
            ]
        });        
        
//-------------------------------Collect Courier--------------------------------

        $('#collect').click(function()
        {   
            var form = $('#collect_courier');
            var status = form.find('input[name="status"]').val();
            var tracking_number = form.find('input[name="tracking_number"]').val();
            
            var data = filter+'&status='+status+'&tracking_number='+tracking_number+'&_token={{ csrf_token() }}';
            console.log(data);
            var url = base_url +'/admin/courier_status_update';
            var return_url = base_url +'/reports/courier_services?'+filter;
            
            if(tracking_number == '')
            {
                toastr_call(2, 'Please Enter Tracking Number');
            }else
            {
                ajax_call2(data, url, return_url);
            }
            return false;
        });
        
//-------------------------------Deliver Courier--------------------------------

        $('#deliver').click(function()
        {   
            var status = $(this).attr('status');
            var data = filter+'&status='+status+'&_token={{ csrf_token() }}';
            
            var url = base_url +'/admin/courier_status_update';
            var return_url = base_url +'/reports/courier_services?'+filter;
            
            bootbox.confirm("Are you sure you want to update status?", function(result) 
            {
                if(result == true)
                {
                    ajax_call2(data, url, return_url);
                }
            });
        });
    });
</script>
