<?php $authentication = \App::make('authentication_helper'); ?>
<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
    @if($authentication->hasPermission(['_superadmin', '_top-up']))
        <div class="col-md-offset-1 col-md-2">
            <a href="{{ URL::route('topup_list', ['category' => 1, 'page' => 2]) }}" class="top-up offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/top-up.png') }}" width="65" height="65" alt=""></i>
                <span>e-Top Up</span>
            </a>
        </div>
    @endif
    @if($authentication->hasPermission(['_superadmin', '_calling-cards']))
        <div class="col-md-2">
            <a href="{{ URL::route('topup_list', ['category' => 2, 'page' => 2]) }}" class="calling-card offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/calling_card.png') }}" width="70" height="50" alt=""></i>
                <span>e-Calling Cards</span>
            </a>
        </div>
    @endif
    @if($authentication->hasPermission(['_superadmin', '_unlocking-mobiles']))
        <div class="col-md-2">
            <a href="{{ URL::route('unlocking_mobile_list', ['page' => 2]) }}" class="unlock-mobiles offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/unlock-mobiles.png') }}" width="39" height="65" alt=""></i>
                <span>e-Unlocking Mobile</span>
            </a>
        </div>
    @endif
    @if($authentication->hasPermission(['_superadmin', '_mobiles']))
        <div class="col-md-2">
            <a href="{{ URL::route('mobile_order_report', ['page' => 2]) }}" class="mobiles offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/mobile.png') }}" width="39" height="65" alt=""></i>
                <span>e-Mobile</span>
            </a>
        </div>
    @endif
    @if($authentication->hasPermission(['_superadmin', '_sim']))
        <div class="col-md-2">
            <a href="{{ URL::route('sim_order_report', ['page' => 2]) }}" class="sim offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/sim.png') }}" width="49" height="65" alt=""></i>
                <span>e-SIM</span>
            </a>
        </div>
    @endif
    @if($authentication->hasPermission(['_superadmin', '_courier-services']))
        <div class="col-md-offset-1 col-md-2">
            <a href="{{ URL::route('courier_services_list', ['type' => 1, 'page' => 2]) }}" class="int-top-up offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/courier.png') }}" width="95" height="60" alt=""></i>
                <span>e-Courier Services</span>
            </a>
        </div>
    @endif
    @if($authentication->hasPermission(['_superadmin', '_cargo-services']))
        <div class="col-md-2">
            <a href="{{ URL::route('courier_services_list', ['type' => 2, 'cargo_type' => 1, 'page' => 2]) }}" class="unlock-mobiles offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/air_cargo.png') }}" width="115" height="54" alt=""></i>
                <span>Air Cargo</span>
            </a>
        </div>  
    @endif
    @if($authentication->hasPermission(['_superadmin', '_cargo-services']))
        <div class="col-md-2">
            <a href="{{ URL::route('courier_services_list', ['type' => 2, 'cargo_type' => 2, 'page' => 2]) }}" class="sim offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/sea_cargo.png') }}" width="99" height="60" alt=""></i>
                <span>Sea Cargo</span>
            </a>
        </div>
    @endif
    @if($authentication->hasPermission(['_superadmin', '_banking']))
        <div class="col-md-2">
            <a href="{{ URL::route('banking_list', ['page' => 2]) }}" class="hotels offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/banking.png') }}" width="65" height="63" alt=""></i>
                <span>e-Banking</span>
            </a>
        </div>
    @endif
    @if($authentication->hasPermission(['_superadmin', '_customer-invoice']))
        <div class="col-md-2">
            <a href="{{ URL::route('sales_report') }}" class="ticket offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/detail_report.png') }}" width="39" height="65" alt=""></i>
                <span>Sales Report</span>                                   
            </a>
        </div>
    @endif
    @if($authentication->hasPermission(['_superadmin', '_calling-cards']))
        <div class="col-md-offset-3 col-md-3">
            <a href="{{ URL::route('topup_report', ['category' => 0]) }}" class="calling-card offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/calling_card.png') }}" width="70" height="50" alt=""></i>
                <span>e-Calling Cards Last 10 <br/>Transactions</span>
            </a>
        </div>
    @endif
    @if($authentication->hasPermission(['_superadmin', '_top-up']))
        <div class="col-md-3">
            <a href="{{ URL::route('topup_report', ['category' => 1]) }}" class="top-up offer-box ajaxify">
                <i class="icon"><img src="{{ asset('packages/mnr_ehub/img/unlock-mobiles.png') }}" width="39" height="65" alt=""></i>
                <span>e-Top Up Last 10 Transactions</span>
            </a>
        </div>
    @endif
</div>