<div class="title">
    <span class="offer">
        @if($category == 1)
            e-TopUp Report
        @else 
            e-Calling Card Report
        @endif
    </span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li>
                <a href="{{ URL::route('reports') }}" class="ajaxify">Reports</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
    <div class="portlet box red">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                {{ $title }}
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover margin-top-20">
                <thead>						
                    <tr>
                        <th>Order #</th>
                        <th>Order Date</th>
                        @if($category == 1)
                            <th>Operator Name</th>
                            <th>Denomination({{ getGlobalValue('currency') }})</th>
                        @else
                            <th>Product Name</th>
                            <th>Value({{ getGlobalValue('currency') }})</th>
                        @endif
                        <th>Pin No</th>
                        <th>Print</th>
                    </tr>
                </thead>	 
                <tbody>
                    @if($topup->count() > 0)
                        @foreach($topup as $row)
                            <tr>
                                <td>{{ $row->transaction_id }}</td>
                                <td>{{ $row->created_at }}</td>
                                <td>{{ $row->pinNumber->product->name }}</td>
                                <td>{{ $row->amount }}</td>
                                <td>{{ $row->pinNumber->pin_number }}</td>
                                <td><a href="{{ URL::route('receipt', ['topup_id' => $row->id, 'page' => 2]) }}" data-toggle="modal" data-target="#receipt"><i class="fa fa-file-text-o"></i></a></td>
                            </tr>
                        @endforeach
                    @else
                        <tr><td colspan="7">No Records found</td></tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="modal fade" id="receipt" tabindex="-1" role="basic" aria-hidden="true">
     <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>