<?php $class = ($page == 1)?'green':'red';?>
@if($page == 2)
    <div class="title">
        <span class="offer">{{ $title }}</span>
    </div>
@endif
<div class="col-md-12">
    @if($page == 2)
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>
                    <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
                </li>
                <li>
                    <a href="{{ URL::route('reports') }}" class="ajaxify">Reports</a>
                </li>
                <li class="active">{{ $title }}</li>
            </ol>
        </div>
    @endif
    <div class="portlet box {{ $class }}">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings"></i>
                {{ $title }}
            </div>
        </div>
        <div class="portlet-body">
            <div class="form-body">
                {{ Form::open(['route' => 'topup_list', 'method' => 'get', 'id' => 'topup_list', 'class' => 'form-horizontal']) }}
                    {{ Form::hidden('category', $category) }}
                    @include('reports.filter')
                {{ Form::close() }}
            </div>
            <table class="table table-striped table-bordered table-hover margin-top-20" id="datatable">
                <thead>						
                    <tr>
                        <th>Order #</th>
                        <th>Order Date</th>
                        @if($category == 1)
                            <th>Operator Name</th>
                            <th>Denomination({{ getGlobalValue('currency') }})</th>
                        @else
                            <th>Product Name</th>
                            <th>Value({{ getGlobalValue('currency') }})</th>
                        @endif
                        <th>Pin No</th>
                        <th>
                            @if($page == 1)
                                Details
                            @else
                                Print
                            @endif
                        </th>
                    </tr>
                </thead>	
                <tbody>                       
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="modal fade" id="receipt" tabindex="-1" role="basic" aria-hidden="true">
     <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
@if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
    @include('reports.user_lookup',['groupId' => 4])
@endif
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();

//------------------------------Topup List Lookup-------------------------------

        $('#topup_list').submit(function()
        {
            lookup($(this));
            return false;        
        });  
        
        var table = $('#datatable');

        table.DataTable({
            'processing': true,
            'serverSide': true,
            'pageLength': 25,
            'pagingType': 'bootstrap_extended',
            'ajax': base_url+'/topup/get_data?page={{ $page }}&category={{ $category }}&user_id={{ $userId }}&date_from={{ $dateFrom }}&date_to={{ $dateTo }}',
            'order': [
                [0, 'desc']
            ],
            'columns': [
                @if(userGroup() == 'agent')
                    { data: 'transaction_id' },
                @else
                    { data: 'agent_transaction_id' },
                @endif                
                { data: 'created_at' },
                { data: 'category_id' },
                { data: 'amount' },
                { data: 'pin_number.pin_number', name: 'pinNumber.pin_number' },
                { data: 'action', orderable: false, searchable: false}
            ]
        });        
    });
</script>
