<div class="modal fade bs-modal-lg" id="basic" tabindex="-1" role="basic" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title">User Lookup</h4>
            </div>
            <div class="modal-body">
                <table class="table table-striped table-bordered table-hover" id="user_datatable">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Email</th>
                    </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn dark btn-outline" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    jQuery(document).ready(function()
    {
//------------------------------Get Customer Data-------------------------------

        var table = $('#user_datatable');

        table.DataTable({
            'processing': true,
            'serverSide': true,
            'pageLength': 25,
            'pagingType': 'bootstrap_extended',
            'ajax': base_url+'/users/get_user_data?groupId={{ $groupId }}',
            'order': [
                [0, 'asc']
            ],
            'columns': [
                { data: 'id' },
                { data: 'user_profile.first_name', name: 'userProfile.first_name' },
                { data: 'user_profile.last_name', name: 'userProfile.last_name' },
                { data: 'email' }
            ]
        });

//-------------------------------Customer Details-------------------------------

        $('#user_datatable').on('click', '.user_details', function ()
        {
            var val   = $(this).attr('id');
            var value = val.split('|');
            $("#user_id").val(value[0]);
            $("#user_name").val(value[1]);
            $("#basic").modal('hide');
        });
    });
</script>