<div class="row">
    <div class="col-md-12">
        <div id="portlet" class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i>
                    Edit Service
                </div>
            </div>
            <div class="portlet-body">
                {{ Form::model($service, [
                    'method' => 'PATCH',
                    'url' => ['/services', $service->id],
                    'id' => 'service', 'class' => 'form-horizontal'
                ]) }}
                    {{ Form::hidden('image_name', null) }}
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Service Name<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('name', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Category<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCategories(3) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Network
                                    </label>
                                    <div class="col-md-8">
                                        {{ getNetworks() }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Country
                                    </label>
                                    <div class="col-md-8">
                                        {{ getMultipleCountries($service->countries->pluck('id')->toArray()) }}
                                    </div>
                                </div>                            
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Brand
                                    </label>
                                    <div class="col-md-8">
                                        {{ getMultipleBrands($service->brands->pluck('id')->toArray()) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Price<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('price', null, ['class' => 'form-control touchspin']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Cost Price
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('cost_price', null, ['class' => 'form-control touchspin']) }}
                                    </div>
                                </div>    
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Sort Order
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('sort_order', 0, ['class' => 'form-control digits']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        API
                                    </label>
                                    <div class="col-md-8">
                                        {{ getApis() }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Image
                                    </label>
                                    <div class="col-md-8">
                                        <div class="fileinput fileinput-new" data-provides="fileinput">
                                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                <?php $image =($service->image_name != '')?'images/service_images/'.$service->image_name.'?'.time():'http://www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image'?>
                                                <img src="{{ $image }}" alt="" /> 
                                            </div>
                                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"> </div>
                                            <div>
                                                <span class="btn default btn-file">
                                                    <span class="fileinput-new"> Select image </span>
                                                    <span class="fileinput-exists"> Change </span>
                                                    <input type="file" name="image" id="image">  
                                                </span>
                                                <a href="javascript:;" class="btn red fileinput-exists" data-dismiss="fileinput"> Remove </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Delivery Time
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('delivery_time', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Process After
                                    </label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            {{ Form::text('process_after', null, ['class' => 'form-control digits']) }}
                                            <span class="input-group-btn">
                                                <button type="button" class="btn btn-success">
                                                    Minutes
                                                </button>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        IMEI Field Type
                                    </label>
                                    <div class="col-md-8">
                                        {{ getImeiFieldType() }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Allow Duplicate IMEI
                                    </label>
                                    <div class="col-md-8">
                                        {{ getAllowDuplicateImei() }}
                                    </div>
                                </div>
                            </div>      
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label col-md-2">
                                        API Services
                                    </label>
                                    <div class="col-md-10">
                                        @if($service->api_id != '')
                                            {{ getApiServices($service->api_id, $service->service_api_id) }}
                                        @else
                                            {{ Form::select('api_service_id', ['' => ''], null, ['data-placeholder' => 'Select API Service', 'id' => 'api_service_id', 'class' => 'form-control select2']) }}
                                        @endif
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-2">
                                        Terms
                                    </label>
                                    <div class="col-md-10">
                                        {{ Form::textarea('terms', null, ['class' => 'summernote form-control']) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-offset-2 col-md-10">
                                {{ Form::submit('Submit', ['class' => 'btn green']) }}
                                <button type="button" id="cancel" class="btn default">Cancel</button>
                            </div>
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
//-------------------------------Get API Services-------------------------------
        
        $('#api_id').change(function()
        {
            var api_id = $(this).val();
            
            App.blockUI({
                target: '#portlet',
                iconOnly: true
            });
            
            $('#api_service_id').empty().trigger('change');
 
            if(api_id != '')
            {
                $.get('services/get_api_services?api_id='+api_id, function(data) 
                {
                    $('#api_service_id').html(data);
                });
                $('#api_service_id').prop('required', true);
            }else
            {
                $('#api_service_id').prop('required', false);
            }
            App.unblockUI('#portlet');
        });
        
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/services';
            return_page(url);
            return false;
        });
    });
</script>