<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-settings"></i>
                    Services
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-toolbar">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="btn-group">
                                <a href="{{ url('/services/create') }}" class="btn sbold green ajaxify"> 
                                    Add New <i class="fa fa-plus"></i>
                                </a>
                            </div>
                            <div class="btn-group">
                                <a href="#auto_generated_service" data-toggle="modal" class="btn sbold green"> 
                                    Auto Generated Services <i class="fa fa-plus"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-body">
                    {{ Form::open(['url' => 'services', 'method' => 'get', 'id' => 'services', 'class' => 'form-horizontal']) }}
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="col-md-3">
                                    <div class="input-icon right">
                                        <label class="control-label margin-bottom-10">Category</label>
                                        {{ getCategories(3, $categoryId) }}
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="input-icon right">
                                        <label class="control-label margin-bottom-10">Price</label>
                                        {{ Form::text('price', $price, ['class' => 'form-control touchspin']) }}
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="input-icon right">
                                        <label class="control-label margin-bottom-10">Status</label>
                                        {{ getStatus2($status) }}
                                    </div>
                                </div>
                                <div class="col-md-3 margin-top-40">
                                    <button class="btn btn-sm yellow filter-submit"><i class="fa fa-search"></i> Search</button>
                                </div>
                            </div>
                        </div>
                    {{ Form::close() }}
                </div>
                {{ Form::open(['url' => '/services/update_price', 'id' => 'update_price']) }}
                    <div class="table-toolbar">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="btn-group pull-right">
                                    {{ Form::submit('Submit', ['class' => 'btn sbold green']) }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <table class="table table-striped table-bordered table-hover" id="datatable">
                        <thead> 
                            <tr>
                                <th>Name</th>
                                <th>Category</th>
                                <th>Price</th>
                                <th>Delivery Time</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@include('services.create_modal')
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        
//-------------------------------Get API Services-------------------------------

        $('#api_id').change(function()
        {
            var api_id = $(this).val();
            
            App.blockUI({
                target: '#portlet',
                iconOnly: true
            });
            
            //$('#category_id').empty().trigger('change');
            //$('#api_service_id').empty().trigger('change');
            
            if(api_id != '')
            {
                $.get('services/'+api_id+'/get_api_categories', function(data) 
                {
                    $('#category_id').html(data);
                });
            }
            App.unblockUI('#portlet');
        });
        
//-------------------------------Get API Services-------------------------------

        $('#category_id').change(function()
        {
            var api_id = $('#api_id').val();
            var category_id = $(this).val();
            
            App.blockUI({
                target: '#portlet',
                iconOnly: true
            });
            
            //$('#api_service_id').empty().trigger('change');
 
            if(api_id != '')
            {
                $.get('services/get_api_services?api_id='+api_id+'&category_id='+category_id, function(data) 
                {
                    $('#api_service_id').html(data);
                });
                $('#api_service_id').prop('required', true);
            }else
            {
                $('#api_service_id').prop('required', false);
            }
            App.unblockUI('#portlet');
        });
        
//--------------------------------Update Status---------------------------------

        $('.update_status').click(function()
        {
            var message;
            var id   = $(this).attr('id');
            var status = $(this).children('button').attr('id');
            
            if(status == 1)
            {
                status  = 0;
                message = 'Are you sure you want to inactive status?';
            }else
            {
                status  = 1;
                message = 'Are you sure you want to active status?';
            }
            
            var data = 'id='+id+'&status='+status+'&_token={{ csrf_token() }}';
            var url  = base_url +'/services/update_status';
            var return_url = base_url+'/services';
            
            bootbox.confirm(message, function(result) 
            {
                if(result == true)
                {
                   ajax_call2(data, url, return_url);
                }
            });
            return false;    
        });
        
        mnreHub.init();     
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//------------------------------------Lookup------------------------------------

        $('#services').submit(function()
        {
            lookup($(this));
            return false;
        });

//-----------------------------------Get Date-----------------------------------

        var table = $('#datatable');

        table.DataTable({
            'processing': true,
            'serverSide': true,
            'pageLength': 25,
            'pagingType': 'bootstrap_extended',
            'ajax': base_url+'/services/get_data?category_id={{ $categoryId }}&price={{ $price }}&status={{ $status }}',
            'order': [
                [1, "asc"]
            ],
            'columns': [
                { data: 'name' },
                { data: 'category_id' },
                { data: 'price' },
                { data: 'delivery_time' },
                { data: 'status' },
                { data: 'action', orderable: false, searchable: false}
            ]
        });        
    });
</script>