<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li>
                <a href="{{ URL::route('instant_credit') }}" class="ajaxify">Instant Credit</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject font-red-sunglo uppercase">Select Credit/Debit Card</span>
            </div>
        </div>
        <div class="portlet-body">
            {{ Form::open(['url' => '/transactions/stripe', 'id' => 'instant_credit_stripe', 'class' => 'form-horizontal']) }}
                {{ Form::hidden('amount', $amount) }}
                <div class="form-body">
                    <div class="col-md-12">
                        @if($userCreditCard->count() > 0)
                            @foreach($userCreditCard as $row)
                                <div class="form-group form-md-line-input">
                                    <div class="input-group">
                                        <label class="mt-radio mt-radio-outline">
                                            <input type="radio" name="card" value="{{ $row->id }}" class="new_card">
                                            <span class="check_top"></span>
                                        </label>
                                        <span class="credit-card">
                                            <a href="#"><img src="{{ asset('packages/mnr_ehub/img/'.$row->brand.'.png') }}" alt="" /> </a>
                                        </span>
                                        <div class="input-group-control">
                                            <?php $cardNumber = substr($row->card_number, -4); ?> 
                                            {{ Form::hidden('card_number_'.$row->id, '************'.$cardNumber) }}
                                            <b>************{{ $cardNumber }}</b> <br/>
                                            Expiration: {{ $row->exp_month }}/{{ $row->exp_year }}
                                        </div>
                                    </div>
                                </div>
                                <hr>
                            @endforeach
                        @endif
                        <div class="form-group form-md-line-input">
                            <div class="input-group">
                                <label class="mt-radio mt-radio-outline">
                                    <input type="radio" name="card" value="0" class="new_card" {{ ($userCreditCard->count() == 0)?'checked':'' }}>
                                    <span></span>
                                </label>
                                <div class="input-group-control">
                                    <b>Add a Debit/Credit Card</b> 
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div id="new_card_info" class="display-hide">
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Card Holder First Name<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('first_name', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Card Type
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCardType() }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Expiration Month & Year 
                                    </label>
                                    <div class="col-md-4">
                                        {{ Form::selectMonth('exp_month', date('M'), ['class' => 'form-control select2']) }} 
                                    </div>
                                    <div class="col-md-4">
                                        {{ Form::selectYear('exp_year', 2016, 2025, date('Y'), ['class' => 'form-control select2']) }} 
                                    </div>
                                </div>
<!--                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Address Line 1<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::textarea('address_line_1', null, ['class' => 'form-control', 'size' => '30x3']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        City<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('address_city', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Country
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCountriesName() }}
                                    </div>
                                </div>-->
                            </div>
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">
                                    <label class="control-label col-md-4">
                                        Card Holder Last Name<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('last_name', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Card Number<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('card_number', null, ['class' => 'form-control', 'autocomplete' => 'off']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        CVC<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('cvc', null, ['class' => 'form-control', 'autocomplete' => 'off']) }}
                                    </div>
                                </div>
<!--                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Address Line 2<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::textarea('address_line_2', null, ['class' => 'form-control', 'size' => '30x3']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Post Code<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::text('address_zip', null, ['class' => 'form-control']) }}
                                    </div>
                                </div>-->
                            </div>                            
                        </div>
                    </div>
                </div>            
                <hr>
                <div class="col-md-12">
                    <h4 class="unlocking margin-bottom-40">Order Summary</h4>
                    <div class="col-md-offset-4 col-md-4 summary-order">
                    <div class="col-md-2">Amount <br>Charges <br><span class="total">Total</span></div>
                    <div class="col-md-2 summary-order-right">{{ getGlobalValue('currency') }}{{ $amount }}<br>{{ getGlobalValue('currency') }}0.00<br><span class="total">{{ getGlobalValue('currency') }}{{ $amount }}</span></div>
                    </div>
                </div>           
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-offset-4 col-md-4">
                            {{ Form::submit('Pay Now', ['class' => 'btn red btn-block']) }}
                        </div>
                    </div>
                </div>
            {{ Form::close() }}
        </div>
    </div>
</div>

<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if($userCreditCard->count() == 0)
            $('#new_card_info').show();
            $('input[name=first_name]').prop('required', true);
            $('input[name=last_name]').prop('required', true);
            $('input[name=card_number]').prop('required', true);
            $('input[name=cvc]').prop('required', true);
//            $('textarea[name=address_line_1]').prop('required', true);
//            $('textarea[name=address_line_2]').prop('required', true);
//            $('input[name=address_city]').prop('required', true);
//            $('input[name=address_zip]').prop('required', true);
//            $('select[name=address_country]').prop('required', true);
        @endif    
        
//----------------------------------New Stream----------------------------------

        $('.new_card').change(function()
        {
            var checked = $('input[name="card"]:checked').val();
            
            if(checked == 0)
            {
                $('#new_card_info').show();
                $('input[name=first_name]').prop('required', true);
                $('input[name=last_name]').prop('required', true);
                $('input[name=card_number]').prop('required', true);
                $('input[name=cvc]').prop('required', true);
//                $('textarea[name=address_line_1]').prop('required', true);
//                $('textarea[name=address_line_2]').prop('required', true);
//                $('input[name=address_city]').prop('required', true);
//                $('input[name=address_zip]').prop('required', true);
//                $('select[name=address_country]').prop('required', true);
            }else
            {
                $('#new_card_info').hide();
                $('input[name=first_name]').prop('required', false);
                $('input[name=last_name]').prop('required', false);
                $('input[name=card_number]').prop('required', false);
                $('input[name=cvc]').prop('required', false);
//                $('textarea[name=address_line_1]').prop('required', false);
//                $('textarea[name=address_line_2]').prop('required', false);
//                $('input[name=address_city]').prop('required', false);
//                $('input[name=address_zip]').prop('required', false);
//                $('select[name=address_country]').prop('required', false);
            }
        });
        
    });
</script>