<?php $companyProfile = getCompanyProfile(); ?>
<div class="col-md-12">
    <div class="title">
        <span class="offer">Receipt</span>
    </div>
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject font-red-sunglo uppercase">Receipt</span>
            </div>
        </div>
        <div class="print-body">
            @if (Session::has('transaction_id'))
                <div id="print-body">
                    <div class="row static-info">
                        <div class="col-md-3 name">Date:</div>
                        <div class="col-md-9 value">{{ $date }}</div>
                    </div>
                    <div class="row static-info">
                        <div class="col-md-12 value">Purchase Amount</div>
                    </div>
                    <div class="row static-info">
                        <div class="col-md-3 name">Credit Card</div>
                        <div class="col-md-9 value">{{ $creditCard }}</div>
                    </div>
                    <div class="row static-info">
                        <div class="col-md-3 name">Amount Selected</div>
                        <div class="col-md-9 value">{{ getGlobalValue('currency') }}{{ $amount }}</div>
                    </div>
                    <div class="row static-info">
                        <div class="col-md-3 name">Charges</div>
                        <div class="col-md-9 value">{{ $charges }}</div>
                    </div>
                    <div class="row static-info">
                        <div class="col-md-3 name">Total</div>
                        <div class="col-md-9 value">{{ getGlobalValue('currency') }}{{ $amount }}</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" onclick="print()" class="btn dark btn-outline">Print</a>
                </div>
            @else
                <div class="row static-info">
                    <div class="col-md-offset-2 col-md-8 value">
                        <h3 class="margin-bottom-30 font-red-sunglo"><b>{{ Session::get('error_message') }}</b></h3>
                    </div>
                </div>
            @endif
        </div>                         
    </div>
</div>
<script type="text/javascript">
    
    jQuery(document).ready(function() 
    {
        mnreHub.init();

        @if (Session::has('transaction_id'))
            toastr_call(1, 'Payment Successful');
        @else
            toastr_call(2, 'Payment Failed');
        @endif
    });
    
    function print()
    {
        var isChrome = !!window.chrome && !!window.chrome.webstore;
        
        var w = window.open('', 'div', 'height=400,width=600');
        w.document.write('<html><head><title>Topup Receipt</title>');  
        w.document.write('<style>.static-info{font-family:arial; font-size:14px; line-height:2.2;}.static-info .value{float:right; font-weight: 600;} .static-info .name{float:left;} .col-md-3{width:25%;} .col-md-9{width:75%;} .col-md-12{width:100%;}</style>');
        w.document.write('</head><body >');
        w.document.write('<img src="{{ asset($companyProfile["company_logo"]) }}" style="width:175px; padding-bottom:30px;">');
        w.document.write('<div class="col-md-12"><div class="static-info name"> {!! $companyProfile["header"] !!}</div></div>');
        w.document.write('<h4>Instant Credit Receipt</h4>');
        w.document.write($('#print-body').html());
        w.document.write('<div class="col-md-12">');
            w.document.write('<div class="static-info name"> {!! $companyProfile["description"] !!} </div>');
            w.document.write('<hr>');
            w.document.write('<div class="static-info name"> {!! $companyProfile["footer"] !!} </div>');
        w.document.write('</div>');
        w.document.write('</body></html>');

        if(isChrome == true)
        {
            setTimeout(function () 
            { 
                w.print();
                w.close(); 
            }, 500);
        }else
        {
            w.print();
            w.close(); 
        }
        return true;
    }
</script>