<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li>
                <a href="{{ URL::route('mnr_services', ['type' => 1]) }}" class="ajaxify">MNR e-Services</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
    <div class="portlet light portlet-fit">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject font-red-sunglo">
                    MNR e-Service Details
                </span>
            </div>
        </div>
        <div class="portlet-body">                
            <div class="form-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="row static-info">
                            <div class="col-md-5 name"> Service Name: </div>
                            <div class="col-md-7 value"> {{ $mnrService->name }} </div>
                        </div>
                        <div class="row static-info">
                            <div class="col-md-5 name"> Category: </div>
                            <div class="col-md-7 value"> {{ $mnrService->category->name }} </div>
                        </div>
                        <div class="row static-info">
                            <div class="col-md-5 name"> Refferel Amount: </div>
                            <div class="col-md-7 value"> {{ $mnrService->amount }} {{ ($mnrService->amount_type == 'fixed')?getGlobalValue('currency'):'%' }} </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        {{ Form::open(['url' => '/transactions/mnr_service', 'id' => 'mnr_service', 'class' => 'form-horizontal']) }}
                            {{ Form::hidden('service_id', $mnrService->id) }}
                            <div class="form-group margin-top-20">
                                <label class="control-label col-md-4">
                                    First Name<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('first_name', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Last Name<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('last_name', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Email<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('email', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Phone No.<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('phone_no', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Mobile No.<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('mobile_no', null, ['class' => 'form-control']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Requirements
                                </label>
                                <div class="col-md-8">
                                    {{ Form::textarea('requirements', null, ['class' => 'form-control', 'size' => '30x3']) }}
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-md-4"></div>
                                <div class="col-md-8">
                                    <button type="button" id="back" class="btn dark">
                                        <i class="fa fa-angle-left"></i> Back
                                    </button>
                                    {{ Form::submit('Refer Now', ['class' => 'btn grey-mint']) }}
                                </div>  
                            </div>
                        {{ Form::close() }} 
                    </div>    
                </div>
            </div>
        </div>
    </div>    
</div>

<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//-------------------------------------Back-------------------------------------

        $('#back').click(function()
        {
            var url = base_url +'/transactions/mnr_services?type=1';
            return_page(url);
            return false;
        });        
    });
</script>