<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
</div>
{{ Form::open(['url' => '/transactions/mobile_order', 'id' => 'mobile_order', 'class' => 'form-horizontal']) }}          
    {{ Form::hidden('grant_total', null, ['id' => 'grant_total']) }}
    {{ Form::hidden('cart', null, ['id' => 'cart']) }}
    <div class="col-md-5">
        <div id="portlet" class="portlet box red">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i> Select Products
                </div>
            </div>
            <div class="portlet-body form">
                <div class="scroller" style="height: 400px;" data-always-visible="1" data-rail-visible="0">
                    <div class="form-body">     
                        <div id="html" class="row">
                            @include('transactions.mobile_order_child', ['brandId' => 0])
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-7">
        <div class="portlet box red">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-settings"></i>
                    Order Summary
                </div>
            </div>
            <div class="portlet-body">
                <div class="scroller" style="height: 370px;" data-always-visible="1" data-rail-visible="0">
                    <table class="table table-striped table-bordered table-hover margin-top-20">
                        <thead> 
                            <tr>
                                <th>Brand</th>
                                <th>Model</th>
                                <th>Type</th>
                                <th>Rate</th>
                                <th>Quantity</th>
                                <th>Total Price ({{ getGlobalValue('currency') }})</th>
                                <th>Delete</th>
                            </tr>
                        </thead>	 
                        <tbody>
                            <tr id='no_record'><td colspan="7">No Records found</td></tr>
                        </tbody>
                    </table>
                    <button type="button" id="back" class="btn dark">
                        <i class="fa fa-angle-left"></i> Back
                    </button>
                    {{ Form::submit('Order Now', ['id' => 'submit', 'class' => 'btn grey-mint']) }}
                </div>
            </div>
        </div>
    </div>
{{ Form::close() }}

<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//----------------------------------Validation----------------------------------

        $('#submit').click(function()
        {
            var length = $('.product_detail').length;
            if(length > 0)
            {
                return true;
            }else
            {
                toastr_call(2, 'Empty Cart..!');
                return false;
            }
        });
        
//----------------------------------Get Models----------------------------------
/*
        $('#html').on('change', '#brand_id', function()
        {
            var brand_id = $(this).val();
            
            var data = 'brand_id='+brand_id+'&_token={{ csrf_token() }}';
            var url  = base_url +'/transactions/get_product_detail';

            ajax_call2(data, url);
        });
*/        
//--------------------------Get Quantity Type & Image---------------------------

        $('#html').on('change', '#brand_id, #model_id, .quantity_type, #quantity', function()
        {
            var data = '';
            var id = $(this).attr('id'); 
            var brand_id = $('#brand_id').val();
            var model_id = $('#model_id').val();
            var quantity_type = $('#quantity_type :checked').val();
            var quantity = $('#quantity').val();
            
            if(id == 'brand_id')
            {
                data = 'brand_id='+brand_id;
            }
            else if(id == 'model_id')
            {
                data = 'brand_id='+brand_id+'&model_id='+model_id;
            }else if(id == 'new' || id == 'refurb')
            {
                data = 'brand_id='+brand_id+'&model_id='+model_id+'&quantity_type='+quantity_type;
            }else if(id == 'quantity')
            {
                data = 'brand_id='+brand_id+'&model_id='+model_id+'&quantity_type='+quantity_type+'&quantity='+quantity;
            }
            data = data+'&_token={{ csrf_token() }}';
            var url  = base_url +'/transactions/get_product_detail';

            ajax_call2(data, url);
        });
        
//---------------------------------Add To Cart----------------------------------
        
        $('#html').on('click', '#add_to_cart', function()
        {
            var length = $('.product_detail').length;
            
            var type_text;
            var total_quantity = 0;
            var total_price    = 0;
            
            var brand_id = $('#brand_id').val();
            var model_id = $('#model_id').val();
            var type     = $('#quantity_type :checked').val();
            var quantity = Number($('#quantity').val());
            var price    = Number($('#price').val());
            var total    = quantity * price;
            
            if(type == 1)
            {
                type_text = 'New';
            }else if(type == 2)
            {
                type_text = 'Refurb';
            }
            
            if(brand_id != '' && model_id != '' && quantity != '')
            {
                var row = '<tr class="product_detail">'+
                            '<td>'+$('#brand_id :selected').text()+'</td>'+
                            '<td>'+$('#model_id :selected').text()+'</td>'+
                            '<td>'+type_text+'</td>'+
                            '<td>'+price+'</td>'+
                            '<td>'+quantity+'</td>'+
                            '<td>'+total+'</td>'+
                            '<td>'+
                                '<input type="hidden" name="brand_ids[]" value="'+brand_id+'">'+
                                '<input type="hidden" name="model_ids[]" value="'+model_id+'">'+
                                '<input type="hidden" name="product_types[]" value="'+type_text+'">'+
                                '<input type="hidden" name="quantities[]" value="'+quantity+'" class="quantity">'+
                                '<input type="hidden" name="prices[]" value="'+price+'">'+
                                '<input type="hidden" name="total[]" value="'+total+'" class="total">'+
                                '<a href="javascript:;" class="delete"><i class="fa fa-trash-o"></i></a>'+
                            '</td>'+
                        '</tr>';
                        
                $('.quantity').each(function() {
                    total_quantity += Number($(this).val());
                });
                
                $('.total').each(function() {
                    total_price += Number($(this).val());
                });
                
                total_quantity = total_quantity + quantity;
                total_price    = total_price + total;
                
                $('#grant_total').val(total_price);
                if(length == 0)
                {
                    row = row + '<tr id="grand"><td colspan="3"></td><td>Total</td><td id="qty">'+total_quantity+'</td><td id="total">'+total_price+'</td><td></td></tr>'
                    $('#no_record').replaceWith(row);
                }else
                {
                    $('#qty').html(total_quantity);
                    $('#total').html(total_price);
                    $('.product_detail:last').after(row);
                }
                
                var data = '_token={{ csrf_token() }}';
                var url  = base_url +'/transactions/get_product_detail';
                
                ajax_call2(data, url);
            }
        });

//---------------------------------Delete Order---------------------------------

        $('.form-horizontal').on('click', '.delete', function()
        {
            var total_quantity = 0;
            var total_price    = 0;
            var length = $('.product_detail').length;   

            if(length == 1)
            {
               $('.product_detail').replaceWith('<tr id="no_record"><td colspan="7">No Records found</td></tr>');
               $('#grand').replaceWith('')
            }else
            {
                $(this).parents('tr').remove();
                
                $('.quantity').each(function() {
                    total_quantity += Number($(this).val());
                });
                
                $('.total').each(function() {
                    total_price += Number($(this).val());
                });
                
                $('#qty').html(total_quantity);
                $('#total').html(total_price);
                
                $('#grant_total').val(total_price);
            }
        });    
        
//-------------------------------------Back-------------------------------------

        $('#back').click(function()
        {
            var url = base_url +'/dashboard';
            return_page(url);
            return false;
        });
    });
</script>