<?php $companyProfile = getCompanyProfile(); ?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
    <h4 class="modal-title">
        @if($page == 1)
            Topup Detail
        @else
            Print Receipt
        @endif
    </h4>
</div>
<div class="modal-body">
    <div class="row static-info">
        <div class="col-md-3 name"> Date: </div>
        <div class="col-md-9 value"> {{ $topup->created_at }} </div>
    </div>
    @if($page == 1 && (userGroup() == 'superadmin' || userGroup() == 'admin'))
        <div class="row static-info">
            <div class="col-md-3 name"> Transaction ID: </div>
            <div class="col-md-9 value"> {{ $topup->agent_transaction_id }} </div>
        </div>
        <div class="row static-info">
            <div class="col-md-3 name"> Customer Transaction ID: </div>
            <div class="col-md-9 value"> {{ $topup->transaction_id }} </div>
        </div>
        <div class="row static-info">
            <div class="col-md-3 name"> Agent Name: </div>
            <div class="col-md-9 value"> {{ $topup->userProfile->first_name }} {{ $topup->userProfile->last_name }}</div>
        </div>
        <div class="row static-info">
            <div class="col-md-3 name"> Category: </div>
            <div class="col-md-9 value"> {{ $topup->category->name }} </div>
        </div>
    @endif
    <div class="row static-info">
        <div class="col-md-3 name"> Product: </div>
        <div class="col-md-9 value"> {{ $topup->pinNumber->product->name }} </div>
    </div>
    <div class="row static-info">
        <div class="col-md-3 name"> Value: </div>
        <div class="col-md-9 value"> {{ getGlobalValue('currency') }}{{ $topup->amount }} </div>
    </div>
    <div class="row static-info">
        <div class="col-md-3 name"> Pin: </div>
        <div class="col-md-9 value"> {{ $topup->pinNumber->pin_number }} </div>
    </div>
    <div class="row static-info">
        <div class="col-md-3 name"> Serial: </div>
        <div class="col-md-9 value"> <b>{{ $topup->pinNumber->serial_number }}</b> </div>
    </div>
    @if($page == 2)
        <div class="row static-info">
            <div class="col-md-12 name"> <br><br>{!! $topup->pinNumber->product->description !!} </div>
        </div>
    @endif
</div>
<div class="modal-footer">
    @if($page == 1)
        <button type="button" class="btn dark btn-outline" data-dismiss="modal">Close</button>
    @else
        <a href="javascript:;" onclick="print()" class="btn dark btn-outline">Print</a>
    @endif
</div>
<script type="text/javascript">
    function print()
    {
        var isChrome = !!window.chrome && !!window.chrome.webstore;
        
        var w = window.open('', 'div', 'height=400,width=600');
        w.document.write('<html><head><title>Topup Receipt</title>');  
        w.document.write('<style>.static-info{font-size:14px; line-height:2.2;}.static-info .value{float:right; font-weight: 600;} .static-info .name{float:left;} .col-md-3{width:25%;} .col-md-9{width:75%;} .col-md-12{width:100%;}</style>');
        w.document.write('</head><body >');
        w.document.write('<center><img src="{{ asset($companyProfile["company_logo"]) }}" style="width:175px; padding-bottom:30px;"></center>');
        w.document.write('<div class="col-md-12"><div class="static-info name"> {!! $companyProfile["header"] !!} </div></div>');
        w.document.write('<h4>Topup Receipt</h4>');
        w.document.write($('.modal-body').html());
        w.document.write('<div class="col-md-12">');
            w.document.write('<div class="static-info name"> {!! $companyProfile["description"] !!} </div>');
            w.document.write('<hr>');
            w.document.write('<div class="static-info name"> {!! $companyProfile["footer"] !!} </div>');
        w.document.write('</div>');
        w.document.write('</body></html>');
        
        if(isChrome == true)
        {
            setTimeout(function () 
            { 
                w.print();
                w.close(); 
            }, 500);
        }else
        {
            w.print();
            w.close(); 
        }
        return true;
    }
</script>
