<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li>
                <a href="{{ URL::route('sim_cover_page') }}" class="ajaxify">e-SIM</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
</div>
{{ Form::open(['url' => '/transactions/sim_order', 'id' => 'sim_order', 'class' => 'form-horizontal']) }}                            
    <div class="col-md-8">
        <div class="portlet box red">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i> Select Networks
                </div>
            </div>
            <div class="portlet-body">
                <div class="scroller" style="height: 305px;" data-always-visible="1" data-rail-visible="0">
                    <table class="table table-striped table-bordered table-hover">
                    <thead> 
                        <tr>
                            <th>S.No.</th>
                            <th>Active</th>
                            <th>Operator Name</th>
                            <th>Quantity</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $a = 1;?>
                            @foreach($networks as $row)
                                <tr class="networks">
                                    <td>{{ $a }}</td>
                                    <td>
                                        <div class="mt-checkbox-inline">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                {{ Form::checkbox('network_id['.$a.']', $row->id, null, ['class' => 'network_id']) }}
                                                <span></span>
                                            </label>
                                        </div>
                                    </td>
                                    <td>{{ $row->name }}</td>
                                    <td>
                                        <?php for($i = 5; $i<=100; $i+=5){
                                            $range[$i] = $i;
                                        }?>
                                        {{ Form::select('quantity['.$a.']', $range, null, ['class' => 'form-control select2 quantity']) }}
                                    </td>
                                </tr>
                                <?php $a++;?>
                            @endforeach          
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="portlet box red">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-settings"></i>
                    Order Summary
                </div>
            </div>
            <div class="portlet-body">
                <div class="scroller" style="height: 305px;" data-always-visible="1" data-rail-visible="0">
                    <div id="html">
                        @if (Session::has('order_no'))
                            <p class="card-title margin-top-20">
                                <span>"Your Order Number is: {{ Session::get('order_no') }}"</span>
                            </p>
                            <p class="card-desc">
                                <span>"Thanks for your order. Your order will be delivered to you in next 48 hrs"</span>
                            </p>
                        @else
                            <table class="table table-striped table-bordered table-hover">
                                <thead> 
                                    <tr>
                                        <th>S.No.</th>
                                        <th>Operator Name</th>
                                        <th>Quantity</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr><td colspan="3">No Records found</td></tr>
                                </tbody>
                            </table>
                            <button type="button" id="back" class="btn dark">
                                <i class="fa fa-angle-left"></i> Back
                            </button>
                            {{ Form::submit('Order Now', ['id' => 'submit', 'class' => 'btn grey-mint']) }}
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
{{ Form::close() }}

<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();

//----------------------------------Validation----------------------------------

        $('#submit').click(function()
        {
            var length = $('.network_id:checked').length;
            if(length > 0)
            {
                return true;
            }else
            {
                toastr_call(2, 'Please select at least one network');
                return false;
            }
        });

//---------------------------------Add to Cart----------------------------------

        $('.network_id, .quantity').change(function()
        {
            var i = 1;
            var length = $('.network_id:checked').length;
            var rows = '<table class="table table-striped table-bordered table-hover">'+
                            '<thead>'+ 
                                '<tr>'+
                                    '<th>S.No.</th>'+
                                    '<th>Operator Name</th>'+
                                    '<th>Quantity</th>'+
                                '</tr>'+
                            '</thead>'+
                            '<tbody>';
            
            if(length > 0)
            {
                $('.networks').each(function() 
                {
                    var checked = $(this).find('td').eq(1).find('.network_id').is(":checked");

                    if(checked)
                    {
                        var operator = $(this).closest('tr').find('td').eq(2).text();
                        var quantity = $(this).closest('tr').find('td').eq(3).find('.quantity option:selected').val();

                        rows += '<tr>'+
                                        '<td>'+i+'</td>'+
                                        '<td>'+operator+'</td>'+
                                        '<td>'+quantity+'</td>'+
                                    '</tr>';
                        i++;
                    }
                });
                }else
                {
                    rows += '<tr><td colspan="4">No Records found</td></tr>';
                }
            
            rows += '</tbody>'+
                        '</table>'+
                        '<button type="button" id="back" class="btn dark">'+
                            '<i class="fa fa-angle-left"></i> Back'+
                        '</button>'+
                        '<button type="submit" class="btn grey-mint" style="margin-left:10px">Order</button>';
            $('#html').html(rows);
        });
        
//-------------------------------------Back-------------------------------------

        $('#html').on('click', '#back', function()
        {    
            var url = base_url +'/dashboard';
            return_page(url);
            return false;
        });
    });
</script>