{{ Form::open(['url' => '/transactions/stripe', 'id' => 'stripe']) }}
    {{ Form::hidden('stripeToken', null, ['id' => 'token']) }}
    {{ Form::hidden('amount', $amount, ['id' => 'token']) }}
{{ Form::close() }}

<script src="{{ asset('packages/metronic/global/plugins/jquery.min.js') }}" type="text/javascript"></script>
<script src="https://checkout.stripe.com/checkout.js"></script>
<script type="text/javascript"> 
    jQuery(document).ready(function() 
    {
        var amount = $("#amount").val();
        var handler = StripeCheckout.configure({
            key: "{{ env('STRIPE_KEY') }}",
            image: '',
            currency: 'GBP',
            token: function(token) {
                $('#token').val(token.id);
                $('#stripe').submit();
            }
        });

        handler.open({
            name: 'GST',
            description: 'GST',
            amount: amount * 100
        });
        
        setInterval(function()
        {
            if(!$('.stripe_checkout_app').is(":visible"))
            {
                window.location = "{{ URL::to('/') }}";
            }
        },5000);
    });
</script>