<div class="col-md-12">
    <div class="title">
        <span class="offer">{{ $title }}</span>
    </div>
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
    {{ Form::open(['url' => '/transactions/topup', 'id' => 'topup', 'class' => 'form-horizontal']) }}
        {{ Form::hidden('send_pin_method', null, ['id' => 'send_pin_method']) }}
        <div id="portlet" class="portlet light portlet-fit">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-settings font-red-sunglo"></i>
                    <span class="caption-subject font-red-sunglo">
                        {{ $title }}
                    </span>
                </div>
                <div class="actions">
                    <div class="btn-group">
                        <button id="product" class="btn red-sunglo btn-outline sbold uppercase">None: {{ getGlobalValue('currency') }}None</button>
                    </div>
                </div>
            </div>
            <div class="portlet-body">                
                <div class="form-body">
                    <div class="row">
                        @if($topup == 0)
                            <div class="col-md-6">
                                <div class="form-group margin-top-20">                            
                                    <label class="control-label col-md-4">
                                        Select Category<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        {{ getCategories(2) }}
                                    </div>
                                </div>
                            </div>
                        @else
                            {{ Form::hidden('category_id', 1) }}
                        @endif
                        <div class="col-md-6">
                            <div class="form-group margin-top-20">
                                <label class="control-label col-md-4">
                                    @if($topup == 1)
                                        Select Operator
                                    @else
                                        Select Product
                                    @endif
                                    <span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    @if($topup == 1)
                                        {{ getProducts(1) }}
                                    @else
                                        {{ Form::select('product_id', ['' => ''], null, ['data-placeholder' => 'Select Product', 'id' => 'product_id', 'class' => 'form-control select2']) }}
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 clearfix">
                            <h4 class="unlocking margin-top-40">Pricing</h4>
<!--                            <p id="price_error" class="font-red-mint display-hide"><strong>Error!</strong> <span></span></p>-->
                            <div class="pricing-content-1">
                                <div id="product_amounts" class="row"></div>
                            </div> 
                        </div>
                        <div class="col-md-6">
                            <div id="contact" class="form-group margin-top-40 display-hide">
                                <label id="contact_label" class="control-label col-md-4">
                                    Email<span class="required"> * </span>
                                </label>
                                <div class="col-md-8">
                                    {{ Form::text('contact_info', null, ['id' => 'contact_info', 'class' => 'form-control']) }}
                                    <div id="submit" class="margin-top-20 display-hide">
                                        {{ Form::submit('Submit', ['class' => 'btn dark']) }}
                                        <button type="button" id="cancel" class="btn grey-mint">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-actions form-body">
                <div class="row">
                    
                </div>
            </div>    
            <div id="send" class="order-btns clearfix margin-top-40">
                <div class="col-md-offset-2 col-md-4">
                    <a href="javascript:;" id="send_email" class="order-opt-link active">
                        <span class="icon"><i class="fa fa-envelope"></i></span>
                        <span id="order-con-id">Send Email</span>
                    </a>
                </div>
<!--                <div class="col-md-4">
                    <a href="javascript:;" id="send_sms" class="order-opt-link">
                        <span class="icon"><i class="fa fa-mobile"></i></span>
                        <span id="order-con-id">Send SMS</span>
                    </a>
                </div>-->
                <div class="col-md-4">
                    <button type="submit" id="print" class="order-opt-link">
                        <span class="icon"><i class="fa fa-print"></i></span>
                        <span id="order-con-id">Print</span>
                    </button>
                </div>
            </div>
        </div>
    {{ Form::close() }}
</div>
<div class="modal fade" id="receipt" data-backdrop="static" tabindex="-1" role="basic" aria-hidden="true">
     <div class="page-loading page-loading-boxed">
        <img src="{{ asset('packages/metronic/global/img/loading-spinner-grey.gif') }}" alt="" class="loading">
        <span>&nbsp;&nbsp;Loading... </span>
    </div>
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>
<!--<style>
    .alert-danger2 {
        background-color: #fbe1e3;
        border-color: #fbe1e3;
        color: #e73d4a;
    }
</style>-->
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//---------------------------------Get Products---------------------------------

        $('#category_id').change(function()
        {
            var category_id = $(this).val();
            
            App.blockUI({
                target: '#portlet',
                iconOnly: true
            });
            
            $('#product_amounts').html('');
            $('#product').html('None: {{ getGlobalValue("currency") }}None');
            $('#product_id').empty().trigger('change');
 
            if(category_id != '')
            {
                $.get('transactions/'+category_id+'/get_products', function(data) 
                {
                    $('#product_id').html(data);
                });
            }   
            App.unblockUI('#portlet');
        });

//-----------------------------Get Product Amounts------------------------------

        $('#product_id').change(function()
        {
            var product_id = $(this).val();
            
            App.blockUI({
                target: '#portlet',
                iconOnly: true
            });
                
            if(product_id != '')
            {
                $.get('transactions/'+product_id+'/get_product_amounts', function(data) 
                {
                    $('#product_amounts').html(data);
                    $('#product').html($('#product_id option:selected').text()+': {{ getGlobalValue("currency") }}None');
                    $('.select-option-link').tooltip();
                });
            }else
            {
                $('#product_amounts').html('');
                $('#product').html('None: {{ getGlobalValue("currency") }}None');
            }
            
            App.unblockUI('#portlet');
        });

//----------------------------------Get Price-----------------------------------

        $('#product_amounts').on('click', '.price', function ()
        {
            var price = $(this).attr('id');

            $('#amount').val(price);
            $('#product').html($('#product_id option:selected').text()+': {{ getGlobalValue("currency") }}'+price);
            $('.ribbon-featured').hide();
            
            $(this).closest('.product-item').find('.ribbon-featured').show();
        });
        
//--------------------------------Send Email/SMS--------------------------------

        $('#send_email, #send_sms').click(function()
        {
            var text;
            var label;
            var id = $(this).attr('id');
            
            if(id == 'send_email')
            {
                text = 'email';
                label = 'Email Address';
                $('#contact_info').attr('email', 'true');
            }else if(id == 'send_sms')
            {
                text = 'sms';
                label = 'Mobile';
                $('#contact_info').attr('phoneUK', 'true');
            }
            
            $('#contact_label').html(label+'<span class="required"> * </span>');
            $('#send_pin_method').val(text);
            $('#contact').show();
            $('#contact_info').attr('required', 'true');
            $('#submit').show();
            $('#send').hide();
        });

//------------------------------------Print-------------------------------------

        $('#print').click(function()
        {
            $('#send_pin_method').val('print');
        });
        
        <?php if (Session::has('topup_id')):?>
            $('#receipt').modal('show');

            $.get(base_url+"/transactions/receipt?topup_id={{ Session::get('topup_id') }}&page=2", function(data) 
            {
                $('.modal-content').html(data);
            });
        <?php endif;?>
            
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            $('#send_pin_method').val('');
            $('#contact_info').val('');
            $('#contact').hide();
            $('#contact_info').removeAttr('required');
            $('#contact_info').removeAttr('email');
            $('#contact_info').removeAttr('mobileUK');
            $('#submit').hide();
            $('#send').show();
        });        
    });
</script>