<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li>
                <a href="{{ URL::route('unlocking_mobile_cover_page') }}" class="ajaxify">e-Unlocking Mobiles</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".page-sidebar">
            <span class="sr-only">Toggle navigation</span>
            <span class="toggle-icon">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </span>
        </button>
    </div>
</div>
<div class="col-md-3">
    <div class="page-sidebar">
        <nav class="navbar" role="navigation">
            <ul class="nav navbar-nav margin-bottom-35">
                <h4 class="unlocking">Categories</h4>
                @foreach($categories as $row)
                    @if ($loop->first)
                        <li class="active">
                    @else
                        <li>
                    @endif
                        <a href="javascript:;" id="{{ $row->id }}" class="category">
                            {{ $row->name }}
                        </a>
                    </li>
                @endforeach
            </ul>
        </nav>
    </div>
</div>
<div class="col-md-9">
    <div class="portlet light portlet-fit">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject font-red-sunglo">
                    e-Unlocking Mobile Services
                </span>
            </div>
        </div>
        <div class="portlet-body">                
            <div class="form-body">
                {{ Form::open(['url' => '/transactions/unlocking_mobile', 'method' => 'get', 'id' => 'unlocking_mobile', 'class' => 'form-horizontal']) }}
                    <div class="form-group margin-top-20">
                        <div class="col-md-3 margin-bottom-20">
                            <label class="control-label margin-bottom-10">Categories</label>
                            {{ getMultipleCategories(3, $request['category_id']) }}
                        </div>
                        <div class="col-md-3 margin-bottom-20">
                            <label class="control-label margin-bottom-10">Countries</label>
                            {{ getMultipleCountries($request['country_id']) }}
                        </div>
                        <div class="col-md-3 margin-bottom-20">
                            <label class="control-label margin-bottom-10">Networks</label>
                            {{ getMultipleNetworks($request['network_id']) }}
                        </div>
                        <div class="col-md-2 margin-bottom-20">
                            <label class="control-label margin-bottom-10">Brands</label>
                            {{ getMultipleBrands($request['brand_id']) }}
                        </div>
                        <div class="col-md-1" style="margin-top:35px">
                            <button type="button" id="search" class="btn btn-icon-only red"> <i class="fa fa-search"></i></button>
                        </div>
                    </div>                
                {{ Form::close() }}   
                @if($services->count() > 0)
                    <?php $categoryNames = array();?>
                    @foreach($services as $row)                
                        <?php $categoryName = $row->category_name;?>
                        @if(!in_array($categoryName, $categoryNames))
                            <?php $categoryNames[] = $categoryName; ?>
                            @if (!$loop->first)
                                    </tbody>
                                </table>
                                <br>
                            @endif
                            <h2 id="category_{{ $row->category_id }}" class="service-unlocking margin-bottom-30">{{ $categoryName }}</h2>
                            <table class="table table-striped table-bordered table-hover">
                                <thead> 
                                    <tr>
                                        <th style="width: 650px">Service Name</th>
                                        <th>Price</th>
                                        <th>Delivery Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                        @endif                            
                                    <tr>
                                        <td>
                                            <a href="{{ URL::route('unlocking_mobile_detail', ['service_id' => $row->id]) }}" class="ajaxify">
                                                {{ $row->service_name }}
                                            </a>
                                        </td>
                                        <td>{{ $row->price }}</td>
                                        <td>{{ $row->delivery_time }}</td>
                                    </tr>
                        @if ($loop->last)
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @else
                    No Records found
                @endif
            </div>
        </div>
    </div>    
</div>

<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();

//-----------------------------------Select2------------------------------------

        $('.select').select2({
            placeholder: "All",
            width: null,
            minimumResultsForSearch: 7
        }).on('change', function() {
            $(this).valid();
        });

//------------------------------Scroll To Category------------------------------

        $('.category').click(function()
        {
            App.scrollTo($('#category_'+$(this).attr('id')));
        });

//------------------------------------Lookup------------------------------------

        $('#search').click(function()
        {
            var val = $('#unlocking_mobile');
            lookup(val);
            return false;
        });        
    });
</script>