<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li>
                <a href="{{ URL::route('unlocking_mobile_cover_page') }}" class="ajaxify">e-Unlocking Mobiles</a>
            </li>
            <li>
                <a href="{{ URL::route('unlocking_mobile') }}" class="ajaxify">IMEI Order</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
    <div class="portlet light portlet-fit">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject font-red-sunglo">
                    e-Unlocking Mobile Service Details
                </span>
            </div>
        </div>
        <div class="portlet-body">                
            <div class="form-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="col-md-7">
                            <div class="row static-info">
                                <div class="col-md-5 name"> Service Name: </div>
                                <div class="col-md-7 value"> {{ $service->name }} </div>
                            </div>
                            <div class="row static-info">
                                <div class="col-md-5 name"> Category: </div>
                                <div class="col-md-7 value"> {{ $service->category->name }} </div>
                            </div>
                            <div class="row static-info">
                                <div class="col-md-5 name"> Network: </div>
                                <div class="col-md-7 value">
                                    @if($service->network_id != '')
                                        {{ $service->network->name }} 
                                    @endif
                                </div>
                            </div>
                            <div class="row static-info">
                                <div class="col-md-5 name"> County: </div>
                                <div class="col-md-7 value"> 
                                    @if(count($service->countries) > 0)
                                        @foreach($service->countries as $row)
                                            {{ $row->name }}
                                            @if(!$loop->last)
                                                ,
                                            @endif
                                        @endforeach
                                    @else
                                        All
                                    @endif 
                                </div>
                            </div>
                            <div class="row static-info">
                                <div class="col-md-5 name"> Brand: </div>
                                <div class="col-md-7 value"> 
                                    @if(count($service->brands) > 0)
                                        @foreach($service->brands as $row)
                                            {{ $row->name }}
                                            @if(!$loop->last)
                                                ,
                                            @endif
                                        @endforeach 
                                    @else
                                        All
                                    @endif
                                </div>
                            </div>
                            <div class="row static-info">
                                <div class="col-md-5 name"> Price: </div>
                                <div class="col-md-7 value"> {{ $service->price }} </div>
                            </div>
                            <div class="row static-info">
                            <div class="col-md-5 name"> Delivery Time: </div>
                            <div class="col-md-7 value"> {{ $service->delivery_time }} </div>
                        </div>
                        </div>
                        <div class="col-md-5">
                            @if($service->image_name != '')
                                <img src="{{ URL::asset('/images/service_images/'.$service->image_name.'?'.time()) }}" border="1" width="100">
                            @else
                                <img src="{{ URL::asset('/packages/mnr_ehub/img/no-image.jpg') }}" border="1" width="100">
                            @endif
                        </div>
                        <div class="col-md-12">
                            <br><b>Terms</b><br><br>
                            <div class="row static-info">
                                <div class="col-md-12 value"> {!! $service->terms !!} </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        {{ Form::open(['url' => '/transactions/unlocking_mobile', 'id' => 'unlocking_mobile', 'class' => 'form-horizontal']) }}
                            {{ Form::hidden('service_id', $service->id) }}
                            {{ Form::hidden('price', $service->price) }}
                            {{ Form::hidden('total_price', $service->price, ['id' => 'total_price']) }}
                            <div class="form-group margin-top-20 imei">
                                <label class="control-label col-md-4">
                                    IMEI<span class="required"> * </span>
                                </label>
                                @if($service->imei_field_type == 1)
                                    <div class="col-md-8">
                                        {{ Form::text('imei_number[]', null, ['id' => 'imei1', 'placeholder' => 'IMEI', 'class' => 'form-control imeis']) }}
                                    </div>
                                @elseif($service->imei_field_type == 2)
                                    <div class="col-md-7">
                                        {{ Form::text('imei_number[]', null, ['id' => 'imei1', 'placeholder' => 'IMEI', 'class' => 'form-control imeis']) }}
                                    </div>
                                    <div class="col-md-1" style="padding-left: 0px">
                                        <a href="javascript:;" id="add_imei" class="btn btn-icon-only grey-mint">
                                            <i class="fa fa-plus"></i>
                                        </a>
                                    </div>
                                @endif
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Comments
                                </label>
                                <div class="col-md-8">
                                    {{ Form::textarea('comments', null, ['class' => 'form-control', 'size' => '30x3']) }}
                                </div>
                            </div>
<!--                            <div class="form-group">
                                <label class="control-label col-md-4">
                                    Send SMS
                                </label>
                                <div class="col-md-8">
                                    <div class="mt-checkbox-inline">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            {{ Form::checkbox('send_sms', 1, false, ['class' => 'form-control']) }}
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>-->
                            <div class="form-group">
                                <div class="col-md-4"></div>
                                <div class="col-md-8">
                                    <button type="button" id="back" class="btn dark">
                                        <i class="fa fa-angle-left"></i> Back
                                    </button>
                                    {{ Form::submit('Order Now', ['class' => 'btn grey-mint']) }}
                                </div>
                            </div>
                        {{ Form::close() }}
                    </div>    
                </div>
            </div>
        </div>
    </div>    
</div>

<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//-----------------------------------Add IMEI-----------------------------------
        
        var i = 2;
        
        $('#add_imei').click(function()
        {
            var add;            
            var length  = $(':input[name="imei_number[]"]').length;
            var length2 = $('.font-red-mint').length;
            total_price(length +1);
            if(length < 15)
            {
                add = $('<div class="form-group imei">'+
                                '<label class="col-md-4"></label>'+
                                '<div class="col-md-7">'+
                                    '<input type="text" name="imei_number[]" placeholder="IMEI" id="imei'+i+'" class="form-control imeis">'+
                                '</div>'+
                                '<div class="col-md-1" style="padding-left: 0px">'+
                                    '<a href="javascript:;" class="btn btn-icon-only red-sunglo delete_imei">'+
                                        '<i class="fa fa-minus"></i>'+
                                    '</a>'+
                                '</div>'+
                            '</div>');
            }else if(length == 15 && length2 < 1)
            {
                add = $('<div class="col-md-4"></div>'+
                        '<div class="col-md-8 margin-bottom-10">'+
                            '<span class="font-red-mint">You only can add maximum 15 IMEI Numbers</span>'+
                        '</div>');
            }
            
            $(".imei:last").after(add);
            
            add = '';
            i++;
            return false;
        });
        
//---------------------------------Remove IMEI----------------------------------

        $('.form-horizontal').on('click', '.delete_imei', function()
        {
            var length  = $(':input[name="imei_number[]"]').length;
            total_price(length -1);
            $(this).parent().parent().remove();
            return false;
        });
        
//---------------------------------Total Price----------------------------------
        
        function total_price(length)
        {
            var price =  {{ $service->price }};
            var total_price = price * length;
            
            $('#total_price').val(total_price);
        }
//-------------------------------------Back-------------------------------------

        $('#back').click(function()
        {
            var url = base_url +'/transactions/unlocking_mobile';
            return_page(url);
            return false;
        });        
    });
</script>