<div class="row">
    <div class="col-md-12">
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-note"></i>
                    {{ isset($user->id) ? ' Edit User' : ' Add User' }}
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-toolbar">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="btn-group">
                                <a href="{{ URL::route('users.profile.edit', ['user_id' => $user->id]) }}" class="btn btn-sm green ajaxify" {{ !isset($user->id) ? 'disabled="disabled"' : '' }}>
                                    Edit Profile
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-6">
                            {{ Form::model($user, ['url' => URL::route('users.edit'), 'id' => 'user', 'class' => 'form-horizontal'] ) }}
                                {{ Form::hidden('id') }}
                                {{ Form::hidden('form_name','user') }}
                                {{-- Field hidden to fix chrome and safari autocomplete bug --}}
                                {{ Form::password('__to_hide_password_autocomplete', ['class' => 'hidden']) }}
                                <h4>Login Data</h4><hr>
                                <div class="form-group margin-top-30 {{ ($errors->first('email') != '')?'has-error':'' }}">
                                    <label class="control-label col-md-4">
                                        Email<span class="required"> * </span>
                                    </label>
                                    <div class="col-md-8">
                                        <div class="input-icon right">
                                            <i class="fa {{ ($errors->first('email') != '')?'fa-warning':'' }} tooltips" data-container="body" data-original-title="{{ $errors->first('email') }}"></i>
                                            {{ Form::text('email', null, ['class' => 'form-control', 'placeholder' => 'Email', 'autocomplete' => 'off']) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group {{ ($errors->first('password') != '')?'has-error':'' }}">
                                    <label class="control-label col-md-4">
                                        {{ isset($user->id) ? 'Change Password ' : 'Password: ' }}
                                    </label>
                                    <div class="col-md-8">
                                        <div class="input-icon right">
                                            <i class="fa {{ ($errors->first('password') != '')?'fa-warning':'' }} tooltips" data-container="body" data-original-title="{{ $errors->first('password') }}"></i>
                                            {{ Form::password('password', ['class' => 'form-control', 'id' => 'password']) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group {{ ($errors->first('password_confirmation') != '')?'has-error':'' }}">
                                    <label class="control-label col-md-4">
                                        Confirm Password
                                    </label>
                                    <div class="col-md-8">
                                        <div class="input-icon right">
                                            <i class="fa {{ ($errors->first('password_confirmation') != '')?'fa-warning':'' }} tooltips" data-container="body" data-original-title="{{ $errors->first('password_confirmation') }}"></i>
                                            {{ Form::password('password_confirmation', ['class' => 'form-control']) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        User Active
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::select('activated', ['1' => 'Yes', '0' => 'No'], (isset($user->activated) && $user->activated) ? $user->activated : '0', ['class' => 'form-control select2'] ) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-4">
                                        Banned
                                    </label>
                                    <div class="col-md-8">
                                        {{ Form::select('banned', ['1' => 'Yes', '0' => 'No'], (isset($user->banned) && $user->banned) ? $user->banned : '0', ['class' => 'form-control select2'] ) }}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-offset-4 col-md-8">
                                        {{ Form::submit('Submit', ['class' => 'btn green']) }}
                                    </div>
                                </div>
                            {{ Form::close() }}
                        </div>
                        <div class="col-md-6">
                            <h4>Groups</h4><hr>
                            @include('laravel-authentication-acl::admin.user.groups')
                            {{-- group permission form --}}
                            <h4>Permissions</h4><hr>
                            {{-- permissions --}}
                            @include('laravel-authentication-acl::admin.user.perm')
                        </div>
                        <div class="col-md-12">
                            <div class="btn-group pull-right margin-top-30  margin-bottom-10">
    <!--                        <button type="button" id="delete" class="btn btn-danger">Delete</button>-->
                                <button type="button" id="cancel" class="btn default">Cancel</button>
                            </div>             
                        </div>                      
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        <?php $message = Session::get('message'); ?>
        @if( isset($message) )
            toastr_call(1, "{{ $message }}");
        @endif
        @if($errors->has('model') )
            toastr_call(2, "{{ $errors->first('model') }}");
        @endif
                    
//---------------------------------Delete User----------------------------------
/*
        $('#delete').click(function()
        {    
            var url = "{{ URL::route('users.delete', ['id' => $user->id, '_token' => csrf_token()]) }}";
            delete_record_acl(url);
        });     
*/
//----------------------------------Add Group-----------------------------------

        <?php if($user->exists): ?>
            $('.add_group').click( function()
            {
                ajax_call_acl($('#group'));
                return false;
            });
        <?php endif; ?>

//---------------------------------Delete Group---------------------------------

        $('.delete_group').click( function()
        {
            var id = $(this).attr('id');
            ajax_call_acl($('form[name='+id+']'));
            return false;
        });
        
//--------------------------------Add Permission--------------------------------

        <?php if($user->exists): ?>
            $('.add_permission').click( function()
            {
                ajax_call_acl($('#permission'));
                return false;
            });
        <?php endif; ?>

//------------------------------Delete Permission-------------------------------

        $('.delete_permission').click( function()
        {
            var id = $(this).attr('id');
            ajax_call_acl($('form[name='+id+']'));
            return false;
        });
    
//------------------------------------Cancel------------------------------------

        $('#cancel').click(function()
        {
            var url = base_url +'/admin/users/list';
            return_page(url);
            return false;
        });
    });
</script>