{{-- add group --}}
{{ Form::open(['route' => 'users.groups.add', 'role' => 'form', 'id' => 'group', 'class' => 'form-horizontal']) }}
    {{ Form::hidden('id', $user->id) }}
    <div class="form-group margin-top-30">
        <div class="col-md-12">
            <div class="input-group select2-bootstrap-prepend">
                <span class="input-group-btn">
                    <button type="button" class="btn btn-default add_group" data-select2-open="single-prepend-text">
                        <span class="glyphicon glyphicon-plus-sign"></span>
                    </button>
                </span>
                {{ Form::select('group_id', $group_values, '', ['class' => 'form-control select2']) }}
            </div>
            <span class="font-red-mint">{{ $errors->first('name') }}</span>
        </div>
    </div>
    @if(! $user->exists)
        <span class="font-red-mint">You need to create the user first.</span>
    @endif
{{ Form::close() }}

{{-- delete group --}}
@if( ! $user->groups->isEmpty() )
    @foreach($user->groups as $group)
        {{ Form::open(['route' => 'users.groups.delete', 'role' => 'form', 'name' => $group->id, 'class' => 'form-horizontal']) }}
            {{ Form::hidden('id', $user->id) }}
            {{ Form::hidden('group_id', $group->id) }}
            <div class="form-group">
                <div class="col-md-12">
                    <div class="input-group">
                        <span class="input-group-btn">
                            <button type="button" id="{{ $group->id }}" class="btn btn-default delete_group" style="background-color: #e1e5ec">
                                <span class="glyphicon glyphicon-minus-sign"></span>
                            </button>
                        </span>
                        {{ Form::text('group_name', $group->name, ['class' => 'form-control', 'readonly' => 'readonly']) }}
                    </div>
                </div>    
            </div>
        {{ Form::close() }}
    @endforeach
@elseif($user->exists)
    <span class="font-red-mint">There is no groups associated to the user.</span>
@endif
