<div class="row">
    <div class="col-md-12">
        <div class="profile-sidebar">
            <div class="portlet light profile-sidebar-portlet ">
                <div class="profile-userpic">
                    <img src="{{ $user_profile->presenter()->avatar(750) }}" class="img-responsive" alt=""> 
                </div>
                <div class="profile-usertitle">
                    <div class="profile-usertitle-name"> {{ $user_profile->first_name }} {{ $user_profile->last_name }} </div>
                </div>
                <div class="profile-usermenu"></div>
            </div>
        </div>
        <div class="profile-content">
            <div class="row">
                <div class="col-md-12">
                    <div class="portlet light ">
                        <div class="portlet-title tabbable-line">
                            <div class="caption caption-md">
                                <i class="icon-globe theme-font hide"></i>
                                <span class="caption-subject font-blue-madison bold uppercase">Profile Account</span>
                            </div>
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#tab_1_1" data-toggle="tab">Personal Info</a>
                                </li>
                                @if(!Config::get('acl_base.use_gravatar'))
                                    <li>
                                        <a href="#tab_1_2" data-toggle="tab">Change Avatar</a>
                                    </li>
                                @endif
<!--                                <li>
                                    <a href="#tab_1_3" data-toggle="tab">Custom Fields</a>
                                </li>-->
                            </ul>
                        </div>
                        <div class="portlet-body">
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab_1_1">
                                    {{ Form::model($user_profile, [
                                        'method' => 'PATCH',
                                        'url' => ['user_profile', $user_profile->id],
                                        'id' => 'user_profile', 'role' => 'form',
                                    ]) }}
                                        {{ Form::hidden('user_profile', 1) }}
                                        {{ Form::hidden('user_id', $user_profile->user_id) }}
                                        @include('laravel-authentication-acl::admin.user.user-info')
                                        @include('laravel-authentication-acl::admin.user.company-profile')
                                        <div class="form-group">
                                            {{ Form::label('credit_limit', 'Credit Limit', ['class' => 'control-label']) }}
                                            {{ Form::text('credit_limit', null, ['class' => 'form-control touchspin', 'placeholder' => 'Credit Limit']) }}
                                        </div>
                                        <div class="form-group">
                                            {{ Form::label('network_commission', 'NetworkCommission', ['class' => 'control-label']) }}
                                            {{ getNetworkCommission() }}
                                        </div><!--                
                                        {{-- custom profile fields --}}
                                        @foreach($custom_profile->getAllTypesWithValues() as $profile_data)
                                            <div class="form-group">
                                                {{ Form::label($profile_data->description, $profile_data->description, ['class' => 'control-label']) }}
                                                {{ Form::text("custom_profile_{$profile_data->id}", $profile_data->value, ['class' => 'form-control', 'placeholder' => $profile_data->description, 'maxlength' => '100']) }}
                                                {{-- delete field --}}
                                            </div>
                                        @endforeach-->
                                        <div class="margiv-top-10">
                                            {{ Form::submit('Save Changes', ['class' => 'btn green']) }}
                                            <a href="javascript:;" class="btn default cancel"> Cancel </a>
                                        </div>
                                    {{ Form::close() }}
                                </div>
                                @if(!Config::get('acl_base.use_gravatar'))
                                    <div class="tab-pane" id="tab_1_2">
                                        @include('laravel-authentication-acl::admin.user.partials.avatar_upload')
                                    </div>
                                @endif
<!--                                <div class="tab-pane" id="tab_1_3">
                                    @if($can_add_fields)
                                        @include('laravel-authentication-acl::admin.user.custom-profile')
                                    @endif
                                </div>-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
                toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
        
//--------------------------------Update Profile--------------------------------
        /*
        $('#update_profile').submit(function()
        {
            ajax_call_acl2($(this));
            return false;
        });*/
        
//------------------------------Add Profile Field-------------------------------
        
        $('.add_profile_field').click( function()
        {
            ajax_call_acl($('#profile_field'));
            return false;
        });
        
//------------------------------Delete Profile Field-------------------------------

        $('.delete_profile_field').click( function()
        {
            var id = $(this).attr('id');
            ajax_call_acl($('form[name='+id+']'));
            return false;
        });
        
//------------------------------------Cancel------------------------------------

        $('.cancel').click(function()
        {
            var url = base_url +'/admin/users/edit?id={{ $user_profile->user_id }}';
            return_page(url);
            return false;
        });
    });
</script>                       