<div class="title">
    <span class="offer">{{ $title }}</span>
</div>
<div class="col-md-12">
    <div class="breadcrumbs">
        <ol class="breadcrumb">
            <li>
                <a href="{{ URL::route('dashboard') }}" class="ajaxify">Home</a>
            </li>
            <li class="active">{{ $title }}</li>
        </ol>
    </div>
</div>
@include('layouts.includes.sidebar')
<div class="col-md-9">
    <div class="portlet light portlet-fit">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject font-red-sunglo">
                    @if($page == 1)
                        Personal Info
                    @elseif($page == 2)
                        Change Avatar
                    @elseif($page == 3)
                        Change Password
                    @elseif($page == 4)
                        Company Information
                    @elseif($page == 5)
                        Invoice Template
                    @endif
                </span>
            </div>
        </div>
        <div class="portlet-body">                
            <div class="form-body">
                @if($page == 1)
                    {{ Form::model($user_profile, [
                        'method' => 'PATCH',
                        'url' => ['user_profile', $user_profile->id],
                        'id' => 'user_profile', 'role' => 'form',
                    ]) }}
                        {{ Form::hidden('user_profile', 0) }}
                        {{ Form::hidden('page', $page) }}
                        @include('laravel-authentication-acl::admin.user.user-info')
                        <div class="margiv-top-10">
                            {{ Form::submit('Save Changes', ['class' => 'btn dark']) }}
                            <a href="javascript:;" class="btn grey-mint"> Cancel </a>
                        </div>
                    {{ Form::close() }}
                @elseif($page == 2)
                    @include('laravel-authentication-acl::admin.user.partials.avatar_upload')
                @elseif($page == 3)
                    @include('laravel-authentication-acl::admin.user.change-password')
                @elseif($page == 4)
                    {{ Form::model($user_profile, [
                        'method' => 'PATCH',
                        'url' => ['user_profile', $user_profile->id],
                        'id' => 'user_profile', 'role' => 'form',
                    ]) }}
                        {{ Form::hidden('user_profile', 0) }}
                        {{ Form::hidden('page', $page) }}
                        @include('laravel-authentication-acl::admin.user.company-profile')
                        <div class="margiv-top-10">
                            {{ Form::submit('Save Changes', ['class' => 'btn dark']) }}
                            <a href="javascript:;" class="btn grey-mint"> Cancel </a>
                        </div>
                    {{ Form::close() }}
                @elseif($page == 5)
                    {{ Form::model($user_profile, [
                        'method' => 'PATCH',
                        'url' => ['company_profile', $user_profile->id],
                        'id' => 'company_profile', 'files' => true, 'role' => 'form',
                    ]) }}
                        {{ Form::hidden('page', $page) }}
                        <div class="form-group">
                            <label class="control-label">
                                Company Logo
                            </label>
                        </div>
                        <div class="form-group">
                            <div class="fileinput fileinput-new" data-provides="fileinput">
                                <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                    <?php $image = ($user_profile->company_logo != '')?'images/company_profiles/'.$user_profile->company_logo.'?'.time():'http://www.placehold.it/200x150/EFEFEF/AAAAAA&amp;text=no+image'?>
                                    <img src="{{ $image }}" alt="" />
                                </div>
                                <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"> </div>
                                <div>
                                    <span class="btn default btn-file">
                                        <span class="fileinput-new"> Select image </span>
                                        <span class="fileinput-exists"> Change </span>
                                        <input type="file" name="image" id="image">
                                    </span>
                                    <a href="javascript:;" class="btn red fileinput-exists" data-dismiss="fileinput"> Remove </a>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <?php $transactionId = ($user_profile->customer_transaction_id == 0)?'Start Transaction ID From':'Last Transaction ID';?>
                            {{ Form::label('customer_transaction_id', $transactionId, ['class' => 'control-label']) }}
                            @if($user_profile->customer_transaction_id == 0)
                                {{ Form::text('customer_transaction_id', null, ['class' => 'form-control digits']) }}
                            @else
                                {{ Form::text('', $user_profile->customer_transaction_id, ['class' => 'form-control', 'disabled' => '']) }}
                            @endif
                        </div>
                        <div class="form-group">
                            <label class="control-label">Description</label>
                            {{ Form::textarea('description', null, ['class' => 'form-control summernote']) }}
                        </div>
                        <div class="form-group">
                            <label class="control-label">Header</label>
                            {{ Form::textarea('header', null, ['class' => 'form-control summernote']) }}
                        </div>
                        <div class="form-group">
                            <label class="control-label">Footer</label>
                            {{ Form::textarea('footer', null, ['class' => 'form-control summernote']) }}
                        </div>
                        <div class="margin-top-10">
                            {{ Form::submit('Submit', ['class' => 'btn dark']) }}
                            <a href="javascript:;" class="btn grey-mint"> Cancel </a>
                        </div>
                    {{ Form::close() }}
                @endif
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();

        @if (Session::has('flash_message'))
            toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
    });
</script>                        